/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import smile.association.FPTree;
import smile.association.ItemSet;

public class FPGrowth
implements Iterable<ItemSet> {
    private int minSupport;
    private FPTree T0;
    private Queue<ItemSet> buffer = new LinkedList<ItemSet>();

    FPGrowth(FPTree tree) {
        this.minSupport = tree.minSupport;
        this.T0 = tree;
    }

    public int size() {
        return this.T0.size();
    }

    @Override
    public Iterator<ItemSet> iterator() {
        return new Iterator<ItemSet>(){
            int[] prefixItemset;
            int[] localItemSupport;
            int i;
            {
                this.prefixItemset = new int[((FPGrowth)FPGrowth.this).T0.maxItemSetSize];
                this.localItemSupport = new int[((FPGrowth)FPGrowth.this).T0.numItems];
                this.i = ((FPGrowth)FPGrowth.this).T0.headerTable.length;
            }

            @Override
            public boolean hasNext() {
                if (FPGrowth.this.buffer.isEmpty() && this.i-- > 0) {
                    FPGrowth.this.grow(((FPGrowth)FPGrowth.this).T0.headerTable[this.i], null, this.localItemSupport, this.prefixItemset);
                }
                return !FPGrowth.this.buffer.isEmpty();
            }

            @Override
            public ItemSet next() {
                return (ItemSet)FPGrowth.this.buffer.poll();
            }
        };
    }

    public static Stream<ItemSet> apply(FPTree tree) {
        FPGrowth growth = new FPGrowth(tree);
        return StreamSupport.stream(growth.spliterator(), false);
    }

    private void grow(FPTree fptree, int[] itemset, int[] localItemSupport, int[] prefixItemset) {
        int i = fptree.headerTable.length;
        while (i-- > 0) {
            this.grow(fptree.headerTable[i], itemset, localItemSupport, prefixItemset);
        }
    }

    private void collect(int[] itemset, int support) {
        this.buffer.offer(new ItemSet(itemset, support));
    }

    private void grow(FPTree.Node node, int[] itemset, int support) {
        int height = 0;
        FPTree.Node currentNode = node;
        while (currentNode != null) {
            ++height;
            currentNode = currentNode.parent;
        }
        if (height > 0) {
            int[] items = new int[height];
            int i = 0;
            FPTree.Node currentNode2 = node;
            while (currentNode2 != null) {
                items[i++] = currentNode2.id;
                currentNode2 = currentNode2.parent;
            }
            int[] itemIndexStack = new int[height];
            int itemIndexStackPos = 0;
            itemset = FPGrowth.insert(itemset, items[itemIndexStack[itemIndexStackPos]]);
            this.collect(itemset, support);
            while (itemIndexStack[0] < height - 1) {
                if (itemIndexStack[itemIndexStackPos] < height - 1) {
                    itemIndexStack[++itemIndexStackPos] = itemIndexStack[itemIndexStackPos - 1] + 1;
                    itemset = FPGrowth.insert(itemset, items[itemIndexStack[itemIndexStackPos]]);
                    this.collect(itemset, support);
                    continue;
                }
                if ((itemset = FPGrowth.drop(itemset)) == null) continue;
                itemIndexStack[--itemIndexStackPos] = itemIndexStack[itemIndexStackPos] + 1;
                itemset[0] = items[itemIndexStack[itemIndexStackPos]];
                this.collect(itemset, support);
            }
        }
    }

    private void grow(FPTree.HeaderTableItem header, int[] itemset, int[] localItemSupport, int[] prefixItemset) {
        int support = header.count;
        int item = header.id;
        itemset = FPGrowth.insert(itemset, item);
        this.collect(itemset, support);
        if (header.node.next == null) {
            FPTree.Node node = header.node;
            this.grow(node.parent, itemset, support);
        } else if (this.getLocalItemSupport(header.node, localItemSupport)) {
            FPTree fptree = this.getLocalFPTree(header.node, localItemSupport, prefixItemset);
            this.grow(fptree, itemset, localItemSupport, prefixItemset);
        }
    }

    private boolean getLocalItemSupport(FPTree.Node node, int[] localItemSupport) {
        boolean end = true;
        Arrays.fill(localItemSupport, 0);
        while (node != null) {
            int support = node.count;
            FPTree.Node parent = node.parent;
            while (parent != null) {
                int n = parent.id;
                localItemSupport[n] = localItemSupport[n] + support;
                parent = parent.parent;
                end = false;
            }
            node = node.next;
        }
        return !end;
    }

    private FPTree getLocalFPTree(FPTree.Node node, int[] localItemSupport, int[] prefixItemset) {
        FPTree tree = new FPTree(this.minSupport, localItemSupport);
        while (node != null) {
            FPTree.Node parent = node.parent;
            int i = prefixItemset.length;
            while (parent != null) {
                if (localItemSupport[parent.id] >= this.minSupport) {
                    prefixItemset[--i] = parent.id;
                }
                parent = parent.parent;
            }
            if (i < prefixItemset.length) {
                tree.add(i, prefixItemset.length, prefixItemset, node.count);
            }
            node = node.next;
        }
        return tree;
    }

    static int[] insert(int[] itemset, int item) {
        if (itemset == null) {
            int[] newItemset = new int[]{item};
            return newItemset;
        }
        int n = itemset.length + 1;
        int[] newItemset = new int[n];
        newItemset[0] = item;
        System.arraycopy(itemset, 0, newItemset, 1, n - 1);
        return newItemset;
    }

    private static int[] drop(int[] itemset) {
        if (itemset.length >= 1) {
            int n = itemset.length - 1;
            int[] newItemset = new int[n];
            System.arraycopy(itemset, 1, newItemset, 0, n);
            return newItemset;
        }
        return null;
    }
}

