/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.validation.RegressionMeasure;

public class MeanAbsoluteDeviation
implements RegressionMeasure {
    public static final MeanAbsoluteDeviation instance = new MeanAbsoluteDeviation();

    @Override
    public double measure(double[] truth, double[] prediction) {
        return MeanAbsoluteDeviation.of(truth, prediction);
    }

    public static double of(double[] truth, double[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int n = truth.length;
        double error = 0.0;
        for (int i = 0; i < n; ++i) {
            error += Math.abs(truth[i] - prediction[i]);
        }
        return error / (double)n;
    }

    public String toString() {
        return "Mean Absolute Deviation";
    }
}

