/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.validation.ClassificationMeasure;
import smile.validation.Precision;
import smile.validation.Recall;

public class FMeasure
implements ClassificationMeasure {
    private double beta = 1.0;

    @Override
    public double measure(int[] truth, int[] prediction) {
        return FMeasure.of(this.beta, truth, prediction);
    }

    public FMeasure() {
        this(1.0);
    }

    public FMeasure(double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("Negative beta");
        }
        this.beta = beta;
    }

    public static double of(double beta, int[] truth, int[] prediction) {
        double beta2 = beta * beta;
        double p = new Precision().measure(truth, prediction);
        double r = new Recall().measure(truth, prediction);
        return (1.0 + beta2) * (p * r) / (beta2 * p + r);
    }
}

