/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor.lsh;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.PriorityQueue;
import smile.neighbor.lsh.HashValueParzenModel;
import smile.neighbor.lsh.MultiProbeHash;
import smile.neighbor.lsh.MultiProbeSample;
import smile.neighbor.lsh.PrH;
import smile.neighbor.lsh.PrZ;
import smile.neighbor.lsh.Probe;
import smile.stat.distribution.GaussianDistribution;
import smile.util.IntArrayList;

public class PosterioriModel
implements Serializable {
    private static final long serialVersionUID = 2L;
    private MultiProbeHash hash;
    private PrH[][][] lookup;

    public PosterioriModel(MultiProbeHash hash, MultiProbeSample[] samples, int Nz, double sigma) {
        this.hash = hash;
        int k = hash.k;
        HashValueParzenModel parzen = new HashValueParzenModel(hash, samples, sigma);
        this.lookup = new PrH[k][][];
        for (int m = 0; m < k; ++m) {
            int minh = (int)Math.floor(hash.umin[m]);
            int maxh = (int)Math.floor(hash.umax[m]);
            int size = Math.min(maxh - minh + 1, Nz);
            double delta = (double)(maxh - minh) / (double)size;
            this.lookup[m] = new PrH[size][];
            for (int n = 0; n < size; ++n) {
                PrH prh;
                int h0;
                parzen.estimate(m, (double)minh + ((double)n + 0.5) * delta);
                GaussianDistribution gaussian = new GaussianDistribution(parzen.mean(), parzen.sd());
                ArrayList<PrH> probs = new ArrayList<PrH>();
                int h = h0 = (int)Math.floor(parzen.mean());
                while (true) {
                    prh = new PrH(h, gaussian.cdf((double)(h + 1)) - gaussian.cdf((double)h));
                    if (prh.pr < 1.0E-7) break;
                    probs.add(prh);
                    ++h;
                }
                h = h0 - 1;
                while (true) {
                    prh = new PrH(h, gaussian.cdf((double)(h + 1)) - gaussian.cdf((double)h));
                    if (prh.pr < 1.0E-7) break;
                    probs.add(prh);
                    --h;
                }
                this.lookup[m][n] = probs.toArray(new PrH[probs.size()]);
                Arrays.sort(this.lookup[m][n]);
            }
        }
    }

    public IntArrayList getProbeSequence(double[] x, double recall, int T) {
        int k = this.hash.k;
        Object[] pz = new PrZ[k];
        for (int i = 0; i < k; ++i) {
            double h = this.hash.hash(x, i);
            double hmin = h - this.hash.umin[i];
            if (hmin < 0.0) {
                hmin = 0.0;
            }
            if (h > this.hash.umax[i]) {
                hmin = this.hash.umax[i] - this.hash.umin[i];
            }
            int qh = (int)(hmin * (double)this.lookup[i].length / (this.hash.umax[i] - this.hash.umin[i] + 1.0));
            pz[i] = new PrZ(i, this.lookup[i][qh]);
        }
        Arrays.sort(pz);
        IntArrayList seq = new IntArrayList();
        seq.add(this.hash.hash(x));
        int[] range = new int[k];
        for (int i = 0; i < k; ++i) {
            range[i] = ((PrZ)pz[i]).prh.length;
        }
        PriorityQueue<Probe> heap = new PriorityQueue<Probe>();
        heap.add(new Probe(range));
        ((Probe)heap.peek()).setProb((PrZ[])pz);
        double pr = ((Probe)heap.peek()).prob;
        seq.add(((Probe)heap.peek()).hash(this.hash, (PrZ[])pz));
        ((Probe)heap.peek()).bucket[0] = 0;
        ((Probe)heap.peek()).last = 0;
        ((Probe)heap.peek()).setProb((PrZ[])pz);
        while (!heap.isEmpty() && pr < recall && seq.size() < T) {
            Probe p2;
            Probe p = (Probe)heap.poll();
            seq.add(p.hash(this.hash, (PrZ[])pz));
            pr += p.prob;
            if (p.isShiftable()) {
                p2 = p.shift();
                p2.setProb((PrZ[])pz);
                heap.offer(p2);
            }
            if (p.isExpandable()) {
                p2 = p.expand();
                p2.setProb((PrZ[])pz);
                heap.offer(p2);
            }
            if (!p.isExtendable()) continue;
            p2 = p.extend();
            p2.setProb((PrZ[])pz);
            heap.offer(p2);
        }
        return seq;
    }
}

