/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import smile.association.FPGrowth;
import smile.association.FPTree;
import smile.association.ItemSet;

class TotalSupportTree
implements Iterable<ItemSet> {
    Node root = new Node();
    int numTransactions = 0;
    private int minSupport;
    private int[] order;
    private Queue<ItemSet> buffer = new LinkedList<ItemSet>();

    public TotalSupportTree(FPTree tree) {
        this.numTransactions = tree.numTransactions;
        this.minSupport = tree.minSupport;
        this.order = tree.order;
        this.root.children = new Node[tree.numFreqItems];
        FPGrowth.apply(tree).forEach(itemset -> this.add(itemset.items, itemset.support));
    }

    public int size() {
        return this.numTransactions;
    }

    @Override
    public Iterator<ItemSet> iterator() {
        return new Iterator<ItemSet>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                if (TotalSupportTree.this.buffer.isEmpty()) {
                    while (this.i < TotalSupportTree.this.root.children.length) {
                        Node child = TotalSupportTree.this.root.children[this.i];
                        if (child != null && child.support >= TotalSupportTree.this.minSupport) {
                            int[] itemset = new int[]{child.id};
                            TotalSupportTree.this.generate(itemset, this.i, child);
                            if (!TotalSupportTree.this.buffer.isEmpty()) {
                                ++this.i;
                                break;
                            }
                        }
                        ++this.i;
                    }
                }
                return !TotalSupportTree.this.buffer.isEmpty();
            }

            @Override
            public ItemSet next() {
                return (ItemSet)TotalSupportTree.this.buffer.poll();
            }
        };
    }

    private void add(int[] itemset, int support) {
        this.add(this.root, 0, itemset.length - 1, itemset, support);
    }

    private void add(Node node, int size, int index, int[] itemset, int support) {
        int item;
        if (node.children == null) {
            node.children = new Node[size];
        }
        if (node.children[item = this.order[itemset[index]]] == null) {
            node.children[item] = new Node(itemset[index]);
        }
        if (index == 0) {
            node.children[item].support += support;
        } else {
            this.add(node.children[item], item, index - 1, itemset, support);
        }
    }

    public int getSupport(int[] itemset) {
        if (this.root.children != null) {
            return this.getSupport(itemset, itemset.length - 1, this.root);
        }
        return 0;
    }

    private int getSupport(int[] itemset, int index, Node node) {
        int item = this.order[itemset[index]];
        Node child = node.children[item];
        if (child != null) {
            if (index == 0) {
                return child.support;
            }
            if (child.children != null) {
                return this.getSupport(itemset, index - 1, child);
            }
        }
        return 0;
    }

    public Stream<ItemSet> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private void generate(int[] itemset, int size, Node node) {
        ItemSet set = new ItemSet(itemset, node.support);
        this.buffer.offer(set);
        if (node.children != null) {
            for (int i = 0; i < size; ++i) {
                Node child = node.children[i];
                if (child == null || child.support < this.minSupport) continue;
                int[] newItemset = FPGrowth.insert(itemset, child.id);
                this.generate(newItemset, i, child);
            }
        }
    }

    class Node {
        int id = -1;
        int support = 0;
        Node[] children = null;

        Node() {
        }

        Node(int id) {
            this.id = id;
        }
    }
}

