/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.util.Arrays;
import smile.validation.ClusterMeasure;
import smile.validation.ContingencyTable;

public class MutualInformation
implements ClusterMeasure {
    public static final MutualInformation instance = new MutualInformation();

    @Override
    public double measure(int[] y1, int[] y2) {
        return MutualInformation.of(y1, y2);
    }

    public static double of(int[] y1, int[] y2) {
        ContingencyTable contingency = new ContingencyTable(y1, y2);
        double n = contingency.n;
        double[] p1 = Arrays.stream(contingency.a).mapToDouble(a -> (double)a / n).toArray();
        double[] p2 = Arrays.stream(contingency.b).mapToDouble(b -> (double)b / n).toArray();
        return MutualInformation.of(n, p1, p2, contingency.table);
    }

    static double of(double n, double[] p1, double[] p2, int[][] count) {
        int n1 = p1.length;
        int n2 = p2.length;
        double I = 0.0;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (count[i][j] <= 0) continue;
                double p = (double)count[i][j] / n;
                I += p * Math.log(p / (p1[i] * p2[j]));
            }
        }
        return I;
    }

    public String toString() {
        return "Mutual Information";
    }
}

