/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.validation.ClassificationMeasure;
import smile.validation.Precision;
import smile.validation.Recall;

public class FMeasure
implements ClassificationMeasure {
    public static final FMeasure instance = new FMeasure();
    private double beta2 = 1.0;

    @Override
    public double measure(int[] truth, int[] prediction) {
        double p = new Precision().measure(truth, prediction);
        double r = new Recall().measure(truth, prediction);
        return (1.0 + this.beta2) * (p * r) / (this.beta2 * p + r);
    }

    public FMeasure() {
    }

    public FMeasure(double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("Negative beta");
        }
        this.beta2 = beta * beta;
    }

    public static double of(int[] truth, int[] prediction) {
        return instance.measure(truth, prediction);
    }
}

