/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Arrays;
import java.util.Properties;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.regression.LinearModel;

public class RidgeRegression {
    public static LinearModel fit(Formula formula, DataFrame data) {
        return RidgeRegression.fit(formula, data, new Properties());
    }

    public static LinearModel fit(Formula formula, DataFrame data, Properties prop) {
        double lambda = Double.valueOf(prop.getProperty("smile.ridge.lambda", "1"));
        return RidgeRegression.fit(formula, data, lambda);
    }

    public static LinearModel fit(Formula formula, DataFrame data, double lambda) {
        int p;
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
        }
        DenseMatrix X = formula.matrix(data, false);
        double[] y = formula.y(data).toDoubleArray();
        int n = X.nrows();
        if (n <= (p = X.ncols())) {
            throw new IllegalArgumentException(String.format("The input matrix is not over determined: %d rows, %d columns", n, p));
        }
        LinearModel model = new LinearModel();
        model.formula = formula;
        model.schema = formula.xschema();
        model.p = p;
        double[] center = X.colMeans();
        double[] scale = X.colSds();
        for (int j = 0; j < scale.length; ++j) {
            if (!MathEx.isZero((double)scale[j])) continue;
            throw new IllegalArgumentException(String.format("The column '%s' is constant", formula.schema().fieldName(j)));
        }
        DenseMatrix scaledX = X.scale(center, scale);
        model.w = new double[p];
        scaledX.atx(y, model.w);
        DenseMatrix XtX = scaledX.ata();
        for (int i = 0; i < p; ++i) {
            XtX.add(i, i, lambda);
        }
        Cholesky cholesky = XtX.cholesky();
        cholesky.solve(model.w);
        for (int j = 0; j < p; ++j) {
            int n2 = j;
            model.w[n2] = model.w[n2] / scale[j];
        }
        double ym = MathEx.mean((double[])y);
        model.b = ym - MathEx.dot((double[])model.w, (double[])center);
        double[] fittedValues = new double[n];
        Arrays.fill(fittedValues, model.b);
        X.axpy(model.w, fittedValues);
        model.fitness(fittedValues, y, ym);
        return model;
    }
}

