/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.QR;
import smile.math.matrix.SVD;
import smile.math.special.Beta;
import smile.regression.LinearModel;

public class OLS {
    private static final Logger logger = LoggerFactory.getLogger(OLS.class);

    public static LinearModel fit(Formula formula, DataFrame data) {
        return OLS.fit(formula, data, new Properties());
    }

    public static LinearModel fit(Formula formula, DataFrame data, Properties prop) {
        String method = prop.getProperty("smile.ols.method", "qr");
        boolean stderr = Boolean.valueOf(prop.getProperty("smile.ols.standard.error", "true"));
        boolean recursive = Boolean.valueOf(prop.getProperty("smile.ols.recursive", "true"));
        return OLS.fit(formula, data, method, stderr, recursive);
    }

    public static LinearModel fit(Formula formula, DataFrame data, String method, boolean stderr, boolean recursive) {
        int p;
        DenseMatrix X = formula.matrix(data, true);
        double[] y = formula.y(data).toDoubleArray();
        int n = X.nrows();
        if (n <= (p = X.ncols() - 1)) {
            throw new IllegalArgumentException(String.format("The input matrix is not over determined: %d rows, %d columns", n, p));
        }
        double[] w1 = new double[p + 1];
        QR qr = null;
        SVD svd = null;
        if (method.equalsIgnoreCase("svd")) {
            svd = X.svd(false);
            svd.solve(y, w1);
        } else {
            try {
                qr = X.qr(false);
                qr.solve(y, w1);
            }
            catch (RuntimeException e) {
                logger.warn("Matrix is not of full rank, try SVD instead");
                method = "svd";
                svd = X.svd(false);
                Arrays.fill(w1, 0.0);
                svd.solve(y, w1);
            }
        }
        LinearModel model = new LinearModel();
        model.formula = formula;
        model.schema = formula.xschema();
        model.p = p;
        model.b = w1[p];
        model.w = new double[p];
        System.arraycopy(w1, 0, model.w, 0, p);
        double[] fittedValues = new double[n];
        X.ax(w1, fittedValues);
        model.fitness(fittedValues, y, MathEx.mean((double[])y));
        DenseMatrix inv = null;
        if (stderr || recursive) {
            Cholesky cholesky = method.equalsIgnoreCase("svd") ? X.ata().cholesky() : qr.CholeskyOfAtA();
            model.V = inv = cholesky.inverse();
        }
        if (stderr) {
            double[][] ttest = new double[p + 1][4];
            model.ttest = ttest;
            for (int i = 0; i <= p; ++i) {
                double t;
                double se;
                ttest[i][0] = w1[i];
                ttest[i][1] = se = model.error * Math.sqrt(inv.get(i, i));
                ttest[i][2] = t = w1[i] / se;
                ttest[i][3] = Beta.regularizedIncompleteBetaFunction((double)(0.5 * (double)model.df), (double)0.5, (double)((double)model.df / ((double)model.df + t * t)));
            }
        }
        return model;
    }
}

