/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.math.matrix.BiconjugateGradient;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.math.matrix.Preconditioner;
import smile.regression.LinearModel;

public class LASSO {
    private static final Logger logger = LoggerFactory.getLogger(LASSO.class);

    public static LinearModel fit(Formula formula, DataFrame data) {
        return LASSO.fit(formula, data, new Properties());
    }

    public static LinearModel fit(Formula formula, DataFrame data, Properties prop) {
        double lambda = Double.valueOf(prop.getProperty("smile.lasso.lambda", "1"));
        double tol = Double.valueOf(prop.getProperty("smile.lasso.tolerance", "1E-4"));
        int maxIter = Integer.valueOf(prop.getProperty("smile.lasso.max.iterations", "1000"));
        return LASSO.fit(formula, data, lambda, tol, maxIter);
    }

    public static LinearModel fit(Formula formula, DataFrame data, double lambda) {
        return LASSO.fit(formula, data, lambda, 1.0E-4, 1000);
    }

    public static LinearModel fit(Formula formula, DataFrame data, double lambda, double tol, int maxIter) {
        DenseMatrix X = formula.matrix(data, false);
        double[] y = formula.y(data).toDoubleArray();
        double[] center = X.colMeans();
        double[] scale = X.colSds();
        for (int j = 0; j < scale.length; ++j) {
            if (!MathEx.isZero((double)scale[j])) continue;
            throw new IllegalArgumentException(String.format("The column '%s' is constant", formula.xschema().fieldName(j)));
        }
        DenseMatrix scaledX = X.scale(center, scale);
        LinearModel model = LASSO.train((Matrix)scaledX, y, lambda, tol, maxIter);
        model.formula = formula;
        model.schema = formula.xschema();
        for (int j = 0; j < model.p; ++j) {
            int n = j;
            model.w[n] = model.w[n] / scale[j];
        }
        double ym = MathEx.mean((double[])y);
        model.b = ym - MathEx.dot((double[])model.w, (double[])center);
        double[] fittedValues = new double[y.length];
        Arrays.fill(fittedValues, model.b);
        X.axpy(model.w, fittedValues);
        model.fitness(fittedValues, y, ym);
        return model;
    }

    static LinearModel train(Matrix x, double[] y, double lambda, double tol, int maxIter) {
        int ntiter;
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int MU = 2;
        double ALPHA = 0.01;
        double BETA = 0.5;
        int MAX_LS_ITER = 100;
        int pcgmaxi = 5000;
        double eta = 0.001;
        int pitr = 0;
        int n = x.nrows();
        int p = x.ncols();
        double[] Y = new double[n];
        double ym = MathEx.mean((double[])y);
        for (int i = 0; i < n; ++i) {
            Y[i] = y[i] - ym;
        }
        double t = Math.min(Math.max(1.0, 1.0 / lambda), (double)(2 * p) / 0.001);
        double pobj = 0.0;
        double dobj = Double.NEGATIVE_INFINITY;
        double s = Double.POSITIVE_INFINITY;
        double[] w = new double[p];
        double[] u = new double[p];
        double[] z = new double[n];
        double[][] f = new double[2][p];
        Arrays.fill(u, 1.0);
        for (int i = 0; i < p; ++i) {
            f[0][i] = w[i] - u[i];
            f[1][i] = -w[i] - u[i];
        }
        double[] neww = new double[p];
        double[] newu = new double[p];
        double[] newz = new double[n];
        double[][] newf = new double[2][p];
        double[] dx = new double[p];
        double[] du = new double[p];
        double[] dxu = new double[2 * p];
        double[] grad = new double[2 * p];
        double[] diagxtx = new double[p];
        Arrays.fill(diagxtx, 2.0);
        double[] nu = new double[n];
        double[] xnu = new double[p];
        double[] q1 = new double[p];
        double[] q2 = new double[p];
        double[] d1 = new double[p];
        double[] d2 = new double[p];
        double[][] gradphi = new double[2][p];
        double[] prb = new double[p];
        double[] prs = new double[p];
        PCGMatrix pcg = new PCGMatrix(x, d1, d2, prb, prs);
        for (ntiter = 0; ntiter <= maxIter; ++ntiter) {
            int lsiter;
            double gap;
            int i;
            x.ax(w, z);
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = i2;
                z[n2] = z[n2] - Y[i2];
                nu[i2] = 2.0 * z[i2];
            }
            x.atx(nu, xnu);
            double maxXnu = MathEx.normInf((double[])xnu);
            if (maxXnu > lambda) {
                double lnu = lambda / maxXnu;
                i = 0;
                while (i < n) {
                    int n3 = i++;
                    nu[n3] = nu[n3] * lnu;
                }
            }
            pobj = MathEx.dot((double[])z, (double[])z) + lambda * MathEx.norm1((double[])w);
            dobj = Math.max(-0.25 * MathEx.dot((double[])nu, (double[])nu) - MathEx.dot((double[])nu, (double[])Y), dobj);
            if (ntiter % 10 == 0) {
                logger.info(String.format("LASSO: primal and dual objective function value after %3d iterations: %.5g\t%.5g%n", ntiter, pobj, dobj));
            }
            if ((gap = pobj - dobj) / dobj < tol) {
                logger.info(String.format("LASSO: primal and dual objective function value after %3d iterations: %.5g\t%.5g%n", ntiter, pobj, dobj));
                break;
            }
            if (s >= 0.5) {
                t = Math.max(Math.min((double)(2 * p * 2) / gap, 2.0 * t), t);
            }
            for (i = 0; i < p; ++i) {
                double q1i = 1.0 / (u[i] + w[i]);
                double q2i = 1.0 / (u[i] - w[i]);
                q1[i] = q1i;
                q2[i] = q2i;
                d1[i] = (q1i * q1i + q2i * q2i) / t;
                d2[i] = (q1i * q1i - q2i * q2i) / t;
            }
            x.atx(z, gradphi[0]);
            for (i = 0; i < p; ++i) {
                gradphi[0][i] = 2.0 * gradphi[0][i] - (q1[i] - q2[i]) / t;
                gradphi[1][i] = lambda - (q1[i] + q2[i]) / t;
                grad[i] = -gradphi[0][i];
                grad[i + p] = -gradphi[1][i];
            }
            for (i = 0; i < p; ++i) {
                prb[i] = diagxtx[i] + d1[i];
                prs[i] = prb[i] * d1[i] - d2[i] * d2[i];
            }
            double normg = MathEx.norm((double[])grad);
            double pcgtol = Math.min(0.1, 0.001 * gap / Math.min(1.0, normg));
            if (ntiter != 0 && pitr == 0) {
                pcgtol *= 0.1;
            }
            BiconjugateGradient bfgs = new BiconjugateGradient(pcgtol, 1, 5000);
            bfgs.setPreconditioner((Preconditioner)pcg);
            double error = bfgs.solve((Matrix)pcg, grad, dxu);
            if (error > pcgtol) {
                pitr = 5000;
            }
            for (int i3 = 0; i3 < p; ++i3) {
                dx[i3] = dxu[i3];
                du[i3] = dxu[i3 + p];
            }
            double phi = MathEx.dot((double[])z, (double[])z) + lambda * MathEx.sum((double[])u) - LASSO.sumlogneg(f) / t;
            s = 1.0;
            double gdx = MathEx.dot((double[])grad, (double[])dxu);
            for (lsiter = 0; lsiter < 100; ++lsiter) {
                int i4;
                for (i4 = 0; i4 < p; ++i4) {
                    neww[i4] = w[i4] + s * dx[i4];
                    newu[i4] = u[i4] + s * du[i4];
                    newf[0][i4] = neww[i4] - newu[i4];
                    newf[1][i4] = -neww[i4] - newu[i4];
                }
                if (MathEx.max((double[][])newf) < 0.0) {
                    x.ax(neww, newz);
                    for (i4 = 0; i4 < n; ++i4) {
                        int n4 = i4;
                        newz[n4] = newz[n4] - Y[i4];
                    }
                    double newphi = MathEx.dot((double[])newz, (double[])newz) + lambda * MathEx.sum((double[])newu) - LASSO.sumlogneg(newf) / t;
                    if (newphi - phi <= 0.01 * s * gdx) break;
                }
                s = 0.5 * s;
            }
            if (lsiter == 100) {
                logger.error("LASSO: Too many iterations of line search.");
                break;
            }
            System.arraycopy(neww, 0, w, 0, p);
            System.arraycopy(newu, 0, u, 0, p);
            System.arraycopy(newf[0], 0, f[0], 0, p);
            System.arraycopy(newf[1], 0, f[1], 0, p);
        }
        if (ntiter == maxIter) {
            logger.error("LASSO: Too many iterations.");
        }
        LinearModel model = new LinearModel();
        model.p = p;
        model.w = w;
        return model;
    }

    private static double sumlogneg(double[][] f) {
        int m = f.length;
        int n = f[0].length;
        double sum = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sum += Math.log(-f[i][j]);
            }
        }
        return sum;
    }

    static class PCGMatrix
    implements Matrix,
    Preconditioner {
        Matrix A;
        Matrix AtA;
        int p;
        double[] d1;
        double[] d2;
        double[] prb;
        double[] prs;
        double[] ax;
        double[] atax;

        PCGMatrix(Matrix A, double[] d1, double[] d2, double[] prb, double[] prs) {
            this.A = A;
            this.d1 = d1;
            this.d2 = d2;
            this.prb = prb;
            this.prs = prs;
            int n = A.nrows();
            this.p = A.ncols();
            this.ax = new double[n];
            this.atax = new double[this.p];
            if (A.ncols() < 10000 && A instanceof DenseMatrix) {
                this.AtA = A.ata();
            }
        }

        public boolean isSymmetric() {
            return true;
        }

        public int nrows() {
            return 2 * this.p;
        }

        public int ncols() {
            return 2 * this.p;
        }

        public double[] ax(double[] x, double[] y) {
            if (this.AtA != null) {
                this.AtA.ax(x, this.atax);
            } else {
                this.A.ax(x, this.ax);
                this.A.atx(this.ax, this.atax);
            }
            for (int i = 0; i < this.p; ++i) {
                y[i] = 2.0 * this.atax[i] + this.d1[i] * x[i] + this.d2[i] * x[i + this.p];
                y[i + this.p] = this.d2[i] * x[i] + this.d1[i] * x[i + this.p];
            }
            return y;
        }

        public double[] atx(double[] x, double[] y) {
            return this.ax(x, y);
        }

        public void solve(double[] b, double[] x) {
            for (int i = 0; i < this.p; ++i) {
                x[i] = (this.d1[i] * b[i] - this.d2[i] * b[i + this.p]) / this.prs[i];
                x[i + this.p] = (-this.d2[i] * b[i] + this.prb[i] * b[i + this.p]) / this.prs[i];
            }
        }

        public Matrix transpose() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Matrix aat() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Matrix ata() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double get(int i, int j) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double apply(int i, int j) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double[] axpy(double[] x, double[] y) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double[] axpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double[] atxpy(double[] x, double[] y) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double[] atxpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

