/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import smile.math.kernel.MercerKernel;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.regression.KernelMachine;

public class GaussianProcessRegression {
    public static <T> KernelMachine<T> fit(T[] x, double[] y, MercerKernel<T> kernel, double lambda) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        DenseMatrix K = Matrix.zeros((int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double k = kernel.k(x[i], x[j]);
                K.set(i, j, k);
                K.set(j, i, k);
            }
            K.add(i, i, lambda);
        }
        Cholesky cholesky = K.cholesky();
        double[] w = (double[])y.clone();
        cholesky.solve(w);
        return new KernelMachine<T>(kernel, x, w);
    }

    public static <T> KernelMachine<T> fit(T[] x, double[] y, T[] t, MercerKernel<T> kernel, double lambda) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        int m = t.length;
        DenseMatrix G = Matrix.zeros((int)n, (int)m);
        for (int j = 0; j < m; ++j) {
            for (i = 0; i < n; ++i) {
                G.set(i, j, kernel.k(x[i], t[j]));
            }
        }
        DenseMatrix K = G.ata();
        for (i = 0; i < m; ++i) {
            for (int j = 0; j <= i; ++j) {
                K.add(i, j, lambda * kernel.k(t[i], t[j]));
                K.set(j, i, K.get(i, j));
            }
        }
        double[] w = new double[m];
        G.atx(y, w);
        LU lu = K.lu(true);
        lu.solve(w);
        return new KernelMachine<T>(kernel, t, w);
    }

    public static <T> KernelMachine<T> nystrom(T[] x, double[] y, T[] t, MercerKernel<T> kernel, double lambda) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        int m = t.length;
        DenseMatrix E = Matrix.zeros((int)n, (int)m);
        for (int j = 0; j < m; ++j) {
            for (i = 0; i < n; ++i) {
                E.set(i, j, kernel.k(x[i], t[j]));
            }
        }
        DenseMatrix W = Matrix.zeros((int)m, (int)m);
        for (i = 0; i < m; ++i) {
            for (int j = 0; j <= i; ++j) {
                double k = kernel.k(t[i], t[j]);
                W.set(i, j, k);
                W.set(j, i, k);
            }
        }
        W.setSymmetric(true);
        EVD eigen = W.eigen();
        DenseMatrix U = eigen.getEigenVectors();
        DenseMatrix D = eigen.getD();
        for (int i2 = 0; i2 < m; ++i2) {
            D.set(i2, i2, 1.0 / Math.sqrt(D.get(i2, i2)));
        }
        DenseMatrix UD = (DenseMatrix)U.abmm((Object)D);
        DenseMatrix UDUt = (DenseMatrix)UD.abtmm((Object)U);
        DenseMatrix L = (DenseMatrix)E.abmm((Object)UDUt);
        DenseMatrix LtL = L.ata();
        for (int i3 = 0; i3 < m; ++i3) {
            LtL.add(i3, i3, lambda);
        }
        Cholesky chol = LtL.cholesky();
        DenseMatrix invLtL = chol.inverse();
        DenseMatrix K = (DenseMatrix)((DenseMatrix)L.abmm((Object)invLtL)).abtmm((Object)L);
        double[] w = new double[n];
        K.atx(y, w);
        for (int i4 = 0; i4 < n; ++i4) {
            w[i4] = (y[i4] - w[i4]) / lambda;
        }
        return new KernelMachine<T>(kernel, x, w);
    }
}

