/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.MathEx;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.projection.LinearProjection;
import smile.stat.distribution.GaussianDistribution;

public class RandomProjection
implements LinearProjection,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final double[] prob = new double[]{0.16666666666666666, 0.6666666666666666, 0.16666666666666666};
    private DenseMatrix projection;

    public RandomProjection(DenseMatrix projection) {
        this.projection = projection;
    }

    public static RandomProjection of(int n, int p) {
        int j;
        int i;
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        double[][] projection = new double[p][n];
        GaussianDistribution gauss = GaussianDistribution.getInstance();
        for (i = 0; i < p; ++i) {
            for (j = 0; j < n; ++j) {
                projection[i][j] = gauss.rand();
            }
        }
        MathEx.unitize((double[])projection[0]);
        for (i = 1; i < p; ++i) {
            for (j = 0; j < i; ++j) {
                double t = -MathEx.dot((double[])projection[i], (double[])projection[j]);
                MathEx.axpy((double)t, (double[])projection[j], (double[])projection[i]);
            }
            MathEx.unitize((double[])projection[i]);
        }
        return new RandomProjection(Matrix.of((double[][])projection));
    }

    public static RandomProjection sparse(int n, int p) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        DenseMatrix projection = Matrix.zeros((int)p, (int)n);
        double scale = Math.sqrt(3.0);
        for (int i = 0; i < p; ++i) {
            for (int j = 0; j < n; ++j) {
                projection.set(i, j, scale * (double)(MathEx.random((double[])prob) - 1));
            }
        }
        return new RandomProjection(projection);
    }

    @Override
    public DenseMatrix getProjection() {
        return this.projection;
    }
}

