/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor.lsh;

import java.util.Arrays;
import smile.neighbor.lsh.Bucket;
import smile.neighbor.lsh.Hash;

public class MultiProbeHash
extends Hash {
    private static final long serialVersionUID = 2L;
    double[] umin;
    double[] umax;

    public MultiProbeHash(int d, int k, double w, int H) {
        super(d, k, w, H);
        this.umin = new double[k];
        this.umax = new double[k];
        Arrays.fill(this.umin, Double.POSITIVE_INFINITY);
        Arrays.fill(this.umax, Double.NEGATIVE_INFINITY);
    }

    private int mphash(double[] x) {
        double[] h = new double[this.k];
        this.a.ax(x, h);
        long g = 0L;
        for (int i = 0; i < this.k; ++i) {
            double hi = (h[i] + this.b[i]) / this.w;
            if (hi < this.umin[i]) {
                this.umin[i] = hi;
            }
            if (hi > this.umax[i]) {
                this.umax[i] = hi;
            }
            g += (long)(this.c[i] * (int)Math.floor(hi));
        }
        int gint = (int)(g % Integer.MAX_VALUE);
        return gint >= 0 ? gint : gint + Integer.MAX_VALUE;
    }

    @Override
    public void add(int index, double[] x) {
        int bucket = this.mphash(x);
        int i = bucket % this.H;
        if (this.table[i] == null) {
            this.table[i] = new Bucket(bucket);
        }
        this.table[i].add(index);
    }
}

