/*
 * Decompiled with CFR 0.152.
 */
package smile.mds;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.MathEx;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;

public class MDS {
    private static final Logger logger = LoggerFactory.getLogger(MDS.class);
    public final double[] scores;
    public final double[][] coordinates;
    public final double[] proportion;

    public MDS(double[] scores, double[] proportion, double[][] coordinates) {
        this.scores = scores;
        this.proportion = proportion;
        this.coordinates = coordinates;
    }

    public static MDS of(double[][] proximity) {
        return MDS.of(proximity, new Properties());
    }

    public static MDS of(double[][] proximity, int k) {
        return MDS.of(proximity, k, false);
    }

    public static MDS of(double[][] proximity, Properties prop) {
        int k = Integer.valueOf(prop.getProperty("smile.mds.k", "2"));
        boolean positive = Boolean.valueOf(prop.getProperty("smile.mds.positive.semidefinite", "false"));
        return MDS.of(proximity, k, positive);
    }

    public static MDS of(double[][] proximity, int k, boolean positive) {
        int m = proximity.length;
        int n = proximity[0].length;
        if (m != n) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (k < 1 || k >= n) {
            throw new IllegalArgumentException("Invalid k = " + k);
        }
        DenseMatrix A = Matrix.zeros((int)n, (int)n);
        DenseMatrix B = Matrix.zeros((int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double x = -0.5 * MathEx.sqr((double)proximity[i][j]);
                A.set(i, j, x);
                A.set(j, i, x);
            }
        }
        double[] mean = A.rowMeans();
        double mu = MathEx.mean((double[])mean);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = A.get(i, j) - mean[i] - mean[j] + mu;
                B.set(i, j, x);
                B.set(j, i, x);
            }
        }
        if (positive) {
            int i;
            DenseMatrix Z = Matrix.zeros((int)(2 * n), (int)(2 * n));
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Z.set(i, n + j, 2.0 * B.get(i, j));
                }
            }
            for (i = 0; i < n; ++i) {
                Z.set(n + i, i, -1.0);
            }
            mean = MathEx.rowMeans((double[][])proximity);
            mu = MathEx.mean((double[])mean);
            for (i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    Z.set(n + i, n + j, 2.0 * (proximity[i][j] - mean[i] - mean[j] + mu));
                }
            }
            double[] evalues = Z.eig();
            double c = MathEx.max((double[])evalues);
            for (int i2 = 0; i2 < n; ++i2) {
                B.set(i2, i2, 0.0);
                for (int j = 0; j < i2; ++j) {
                    double x = -0.5 * MathEx.sqr((double)(proximity[i2][j] + c));
                    B.set(i2, j, x);
                    B.set(j, i2, x);
                }
            }
        }
        B.setSymmetric(true);
        EVD eigen = B.eigen(k);
        if (eigen.getEigenValues().length < k) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)k, (Object)eigen.getEigenValues().length);
            k = eigen.getEigenValues().length;
        }
        double[][] coordinates = new double[n][k];
        for (int j = 0; j < k; ++j) {
            if (eigen.getEigenValues()[j] < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", k));
            }
            double scale = Math.sqrt(eigen.getEigenValues()[j]);
            for (int i = 0; i < n; ++i) {
                coordinates[i][j] = eigen.getEigenVectors().get(i, j) * scale;
            }
        }
        double[] eigenvalues = eigen.getEigenValues();
        double[] proportion = (double[])eigenvalues.clone();
        MathEx.unitize1((double[])proportion);
        return new MDS(eigenvalues, proportion, coordinates);
    }
}

