/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;

class NearestNeighborGraph {
    private static final Logger logger = LoggerFactory.getLogger(NearestNeighborGraph.class);
    public final int[] index;
    public final Graph graph;

    public NearestNeighborGraph(int[] index, Graph graph) {
        this.index = index;
        this.graph = graph;
    }

    public static Graph of(double[][] data, int k, Optional<EdgeConsumer> sideEffect) {
        LinearSearch<double[]> knn = new LinearSearch<double[]>((T[])data, (Distance<double[]>)new EuclideanDistance());
        int n = data.length;
        AdjacencyList graph = new AdjacencyList(n);
        if (sideEffect.isPresent()) {
            for (int i = 0; i < n; ++i) {
                EdgeConsumer consumer = sideEffect.get();
                Neighbor<double[], double[]>[] neighbors = knn.knn(data[i], k);
                int v1 = i;
                for (int j = 0; j < neighbors.length; ++j) {
                    int v2 = neighbors[j].index;
                    double weight = neighbors[j].distance;
                    graph.setWeight(v1, v2, weight);
                    consumer.accept(v1, v2, weight, j);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (Neighbor<double[], double[]> neighbor : knn.knn(data[i], k)) {
                    graph.setWeight(i, neighbor.index, neighbor.distance);
                }
            }
        }
        return graph;
    }

    public static NearestNeighborGraph largest(Graph graph) {
        int[] index;
        int n = graph.getNumVertices();
        int[][] cc = graph.bfs();
        if (cc.length == 1) {
            index = new int[n];
            for (int i = 0; i < n; ++i) {
                index[i] = i;
            }
        } else {
            n = 0;
            int largest = 0;
            for (int i = 0; i < cc.length; ++i) {
                if (cc[i].length <= n) continue;
                largest = i;
                n = cc[i].length;
            }
            logger.info("{} connected components, largest one has {} samples.", (Object)cc.length, (Object)n);
            index = cc[largest];
            graph = graph.subgraph(index);
        }
        return new NearestNeighborGraph(index, graph);
    }

    public static interface EdgeConsumer {
        public void accept(int var1, int var2, double var3, int var5);
    }
}

