/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.Graph;
import smile.manifold.NearestNeighborGraph;
import smile.math.MathEx;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;

public class IsoMap
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(IsoMap.class);
    public final int[] index;
    public final double[][] coordinates;
    public final Graph graph;

    public IsoMap(int[] index, double[][] coordinates, Graph graph) {
        this.index = index;
        this.coordinates = coordinates;
        this.graph = graph;
    }

    public static IsoMap of(double[][] data, int k) {
        return IsoMap.of(data, k, 2, true);
    }

    public static IsoMap of(double[][] data, int k, int d, boolean conformal) {
        Graph graph;
        if (!conformal) {
            graph = NearestNeighborGraph.of(data, k, Optional.empty());
        } else {
            int n = data.length;
            double[] M2 = new double[n];
            graph = NearestNeighborGraph.of(data, k, Optional.of((v1, v2, weight, j) -> {
                int n = v1;
                M2[n] = M2[n] + weight;
            }));
            for (int i = 0; i < n; ++i) {
                M2[i] = Math.sqrt(M2[i] / (double)k);
            }
            for (Graph.Edge edge : graph.getEdges()) {
                edge.weight /= M2[edge.v1] * M2[edge.v2];
            }
        }
        NearestNeighborGraph nng = NearestNeighborGraph.largest(graph);
        int[] index = nng.index;
        int n = index.length;
        graph = nng.graph;
        double[][] D = graph.dijkstra();
        for (int i = 0; i < n; ++i) {
            for (int j2 = 0; j2 < i; ++j2) {
                D[i][j2] = -0.5 * D[i][j2] * D[i][j2];
                D[j2][i] = D[i][j2];
            }
        }
        double[] mean = MathEx.rowMeans((double[][])D);
        double mu = MathEx.mean((double[])mean);
        DenseMatrix B = Matrix.zeros((int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j3 = 0; j3 <= i; ++j3) {
                double b = D[i][j3] - mean[i] - mean[j3] + mu;
                B.set(i, j3, b);
                B.set(j3, i, b);
            }
        }
        B.setSymmetric(true);
        EVD eigen = B.eigen(d);
        if (eigen.getEigenValues().length < d) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)d, (Object)eigen.getEigenValues().length);
            d = eigen.getEigenValues().length;
        }
        DenseMatrix V = eigen.getEigenVectors();
        double[][] coordinates = new double[n][d];
        for (int j4 = 0; j4 < d; ++j4) {
            if (eigen.getEigenValues()[j4] < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", d));
            }
            double scale = Math.sqrt(eigen.getEigenValues()[j4]);
            for (int i = 0; i < n; ++i) {
                coordinates[i][j4] = V.get(i, j4) * scale;
            }
        }
        return new IsoMap(index, coordinates, graph);
    }
}

