/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import smile.gap.BitString;
import smile.math.MathEx;

public enum Crossover {
    SINGLE_POINT{

        @Override
        public BitString[] apply(BitString father, BitString mother) {
            int length = father.length;
            byte[] dad = father.bits();
            byte[] mom = mother.bits();
            byte[] son = new byte[length];
            byte[] daughter = new byte[length];
            int point = 0;
            while (point == 0) {
                point = MathEx.randomInt((int)length);
            }
            System.arraycopy(dad, 0, son, 0, point);
            System.arraycopy(mom, point, son, point, length - point);
            System.arraycopy(mom, 0, daughter, 0, point);
            System.arraycopy(dad, point, daughter, point, length - point);
            BitString[] offsprings = new BitString[]{father.newInstance(son), mother.newInstance(daughter)};
            return offsprings;
        }
    }
    ,
    TWO_POINT{

        @Override
        public BitString[] apply(BitString father, BitString mother) {
            int length = father.length;
            byte[] dad = father.bits();
            byte[] mom = mother.bits();
            byte[] son = new byte[length];
            byte[] daughter = new byte[length];
            int point1 = 0;
            while (point1 == 0 || point1 == length - 1) {
                point1 = MathEx.randomInt((int)length);
            }
            int point2 = 0;
            while (point2 == point1 || point2 == 0 || point2 == length - 1) {
                point2 = MathEx.randomInt((int)length);
            }
            if (point2 < point1) {
                int p = point1;
                point1 = point2;
                point2 = p;
            }
            System.arraycopy(dad, 0, son, 0, point1);
            System.arraycopy(mom, point1, son, point1, point2 - point1);
            System.arraycopy(dad, point2, son, point2, length - point2);
            System.arraycopy(mom, 0, daughter, 0, point1);
            System.arraycopy(dad, point1, daughter, point1, point2 - point1);
            System.arraycopy(mom, point2, daughter, point2, length - point2);
            BitString[] offsprings = new BitString[]{father.newInstance(son), mother.newInstance(daughter)};
            return offsprings;
        }
    }
    ,
    UNIFORM{

        @Override
        public BitString[] apply(BitString father, BitString mother) {
            int length = father.length;
            byte[] dad = father.bits();
            byte[] mom = mother.bits();
            byte[] son = new byte[length];
            byte[] daughter = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (MathEx.random() < 0.5) {
                    son[i] = dad[i];
                    daughter[i] = mom[i];
                    continue;
                }
                son[i] = mom[i];
                daughter[i] = dad[i];
            }
            BitString[] offsprings = new BitString[]{father.newInstance(son), mother.newInstance(daughter)};
            return offsprings;
        }
    };


    public abstract BitString[] apply(BitString var1, BitString var2);
}

