/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.util.Properties;
import smile.classification.DiscriminantAnalysis;
import smile.classification.SoftClassifier;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.util.IntSet;
import smile.util.Strings;

public class QDA
implements SoftClassifier<double[]> {
    private static final long serialVersionUID = 2L;
    private final int p;
    private final int k;
    private final double[] logppriori;
    private final double[] priori;
    private final double[][] mu;
    private final double[][] eigen;
    private final DenseMatrix[] scaling;
    private final IntSet labels;

    public QDA(double[] priori, double[][] mu, double[][] eigen, DenseMatrix[] scaling) {
        this(priori, mu, eigen, scaling, IntSet.of((int)priori.length));
    }

    public QDA(double[] priori, double[][] mu, double[][] eigen, DenseMatrix[] scaling, IntSet labels) {
        this.k = priori.length;
        this.p = mu[0].length;
        this.priori = priori;
        this.mu = mu;
        this.eigen = eigen;
        this.scaling = scaling;
        this.labels = labels;
        this.logppriori = new double[this.k];
        for (int i = 0; i < this.k; ++i) {
            double logev = 0.0;
            for (int j = 0; j < this.p; ++j) {
                logev += Math.log(eigen[i][j]);
            }
            this.logppriori[i] = Math.log(priori[i]) - 0.5 * logev;
        }
    }

    public static QDA fit(Formula formula, DataFrame data) {
        return QDA.fit(formula, data, new Properties());
    }

    public static QDA fit(Formula formula, DataFrame data, Properties prop) {
        double[][] x = formula.x(data).toArray();
        int[] y = formula.y(data).toIntArray();
        return QDA.fit(x, y, prop);
    }

    public static QDA fit(double[][] x, int[] y) {
        return QDA.fit(x, y, null, 1.0E-4);
    }

    public static QDA fit(double[][] x, int[] y, Properties prop) {
        double[] priori = Strings.parseDoubleArray((String)prop.getProperty("smile.qda.priori"));
        double tol = Double.valueOf(prop.getProperty("smile.qda.tolerance", "1E-4"));
        return QDA.fit(x, y, priori, tol);
    }

    public static QDA fit(double[][] x, int[] y, double[] priori, double tol) {
        DiscriminantAnalysis da = DiscriminantAnalysis.fit(x, y, priori, tol);
        DenseMatrix[] cov = DiscriminantAnalysis.cov(x, y, da.mu, da.ni);
        int k = cov.length;
        int p = cov[0].nrows();
        double[][] eigen = new double[k][];
        DenseMatrix[] scaling = new DenseMatrix[k];
        tol *= tol;
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < p; ++j) {
                if (!(cov[i].get(j, j) < tol)) continue;
                throw new IllegalArgumentException(String.format("Class %d covariance matrix (column %d) is close to singular.", i, j));
            }
            EVD evd = cov[i].eigen();
            for (double s : evd.getEigenValues()) {
                if (!(s < tol)) continue;
                throw new IllegalArgumentException(String.format("Class %d covariance matrix is close to singular.", i));
            }
            eigen[i] = evd.getEigenValues();
            scaling[i] = evd.getEigenVectors();
        }
        return new QDA(da.priori, da.mu, eigen, scaling, da.labels);
    }

    public double[] priori() {
        return this.priori;
    }

    @Override
    public int predict(double[] x) {
        return this.predict(x, new double[this.k]);
    }

    @Override
    public int predict(double[] x, double[] posteriori) {
        if (x.length != this.p) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.p));
        }
        double[] d = new double[this.p];
        double[] ux = new double[this.p];
        for (int i = 0; i < this.k; ++i) {
            double[] mui = this.mu[i];
            for (int j = 0; j < this.p; ++j) {
                d[j] = x[j] - mui[j];
            }
            this.scaling[i].atx(d, ux);
            double f = 0.0;
            double[] ev = this.eigen[i];
            for (int j = 0; j < this.p; ++j) {
                f += ux[j] * ux[j] / ev[j];
            }
            posteriori[i] = this.logppriori[i] - 0.5 * f;
        }
        return this.labels.valueOf(MathEx.softmax((double[])posteriori));
    }
}

