/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.base.cart.CART;
import smile.base.cart.SplitRule;
import smile.classification.ClassLabels;
import smile.classification.DataFrameClassifier;
import smile.classification.DecisionTree;
import smile.classification.SoftClassifier;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.math.MathEx;
import smile.util.IntSet;
import smile.util.Strings;

public class AdaBoost
implements SoftClassifier<Tuple>,
DataFrameClassifier {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(AdaBoost.class);
    private Formula formula;
    private int k;
    private DecisionTree[] trees;
    private double[] alpha;
    private double[] error;
    private double[] importance;
    private IntSet labels;

    public AdaBoost(Formula formula, int k, DecisionTree[] trees, double[] alpha, double[] error, double[] importance) {
        this(formula, k, trees, alpha, error, importance, IntSet.of((int)k));
    }

    public AdaBoost(Formula formula, int k, DecisionTree[] trees, double[] alpha, double[] error, double[] importance, IntSet labels) {
        this.formula = formula;
        this.k = k;
        this.trees = trees;
        this.alpha = alpha;
        this.error = error;
        this.importance = importance;
        this.labels = labels;
    }

    public static AdaBoost fit(Formula formula, DataFrame data) {
        return AdaBoost.fit(formula, data, new Properties());
    }

    public static AdaBoost fit(Formula formula, DataFrame data, Properties prop) {
        int ntrees = Integer.valueOf(prop.getProperty("smile.adaboost.trees", "500"));
        int maxDepth = Integer.valueOf(prop.getProperty("smile.adaboost.max.depth", "20"));
        int maxNodes = Integer.valueOf(prop.getProperty("smile.adaboost.max.nodes", "6"));
        int nodeSize = Integer.valueOf(prop.getProperty("smile.adaboost.node.size", "1"));
        return AdaBoost.fit(formula, data, ntrees, maxDepth, maxNodes, nodeSize);
    }

    public static AdaBoost fit(Formula formula, DataFrame data, int ntrees, int maxDepth, int maxNodes, int nodeSize) {
        int i;
        if (ntrees < 1) {
            throw new IllegalArgumentException("Invalid number of trees: " + ntrees);
        }
        DataFrame x = formula.x(data);
        BaseVector y = formula.y(data);
        ClassLabels codec = ClassLabels.fit(y);
        int[][] order = CART.order(x);
        int k = codec.k;
        int n = data.size();
        int[] samples = new int[n];
        double[] w = new double[n];
        boolean[] err = new boolean[n];
        for (int i2 = 0; i2 < n; ++i2) {
            w[i2] = 1.0;
        }
        double guess = 1.0 / (double)k;
        double b = Math.log(k - 1);
        int failures = 0;
        DecisionTree[] trees = new DecisionTree[ntrees];
        double[] alpha = new double[ntrees];
        double[] error = new double[ntrees];
        for (int t = 0; t < ntrees; ++t) {
            int[] rand;
            double W = MathEx.sum((double[])w);
            int i3 = 0;
            while (i3 < n) {
                int n2 = i3++;
                w[n2] = w[n2] / W;
            }
            Arrays.fill(samples, 0);
            int[] nArray = rand = MathEx.random((double[])w, (int)n);
            int n3 = nArray.length;
            for (int j = 0; j < n3; ++j) {
                int s;
                int n4 = s = nArray[j];
                samples[n4] = samples[n4] + 1;
            }
            logger.info("Training {} tree", (Object)Strings.ordinal((int)(t + 1)));
            trees[t] = new DecisionTree(x, codec.y, codec.field, k, SplitRule.GINI, maxDepth, maxNodes, nodeSize, -1, samples, order);
            for (int i4 = 0; i4 < n; ++i4) {
                err[i4] = trees[t].predict((Tuple)x.get(i4)) != y.getInt(i4);
            }
            double e = 0.0;
            for (i = 0; i < n; ++i) {
                if (!err[i]) continue;
                e += w[i];
            }
            if (1.0 - e <= guess) {
                logger.error(String.format("Skip the weak classifier %d makes %.2f%% weighted error", t, 100.0 * e));
                if (++failures > 3) {
                    trees = Arrays.copyOf(trees, t);
                    alpha = Arrays.copyOf(alpha, t);
                    error = Arrays.copyOf(error, t);
                    break;
                }
                --t;
                continue;
            }
            failures = 0;
            error[t] = e;
            alpha[t] = Math.log((1.0 - e) / Math.max(1.0E-10, e)) + b;
            double a = Math.exp(alpha[t]);
            for (int i5 = 0; i5 < n; ++i5) {
                if (!err[i5]) continue;
                int n5 = i5;
                w[n5] = w[n5] * a;
            }
        }
        double[] importance = new double[x.ncols()];
        for (DecisionTree tree : trees) {
            double[] imp = tree.importance();
            for (i = 0; i < imp.length; ++i) {
                int n6 = i;
                importance[n6] = importance[n6] + imp[i];
            }
        }
        return new AdaBoost(formula, k, trees, alpha, error, importance, codec.labels);
    }

    @Override
    public Formula formula() {
        return this.formula;
    }

    @Override
    public StructType schema() {
        return this.trees[0].schema();
    }

    public double[] importance() {
        return this.importance;
    }

    public int size() {
        return this.trees.length;
    }

    public DecisionTree[] trees() {
        return this.trees;
    }

    public void trim(int ntrees) {
        if (ntrees > this.trees.length) {
            throw new IllegalArgumentException("The new model size is larger than the current size.");
        }
        if (ntrees <= 0) {
            throw new IllegalArgumentException("Invalid new model size: " + ntrees);
        }
        if (ntrees < this.trees.length) {
            this.trees = Arrays.copyOf(this.trees, ntrees);
            this.alpha = Arrays.copyOf(this.alpha, ntrees);
            this.error = Arrays.copyOf(this.error, ntrees);
        }
    }

    @Override
    public int predict(Tuple x) {
        Tuple xt = this.formula.x(x);
        double[] y = new double[this.k];
        for (int i = 0; i < this.trees.length; ++i) {
            int n = this.trees[i].predict(xt);
            y[n] = y[n] + this.alpha[i];
        }
        return this.labels.valueOf(MathEx.whichMax((double[])y));
    }

    @Override
    public int predict(Tuple x, double[] posteriori) {
        Arrays.fill(posteriori, 0.0);
        for (int i = 0; i < this.trees.length; ++i) {
            int n = this.trees[i].predict(x);
            posteriori[n] = posteriori[n] + this.alpha[i];
        }
        double sum = MathEx.sum((double[])posteriori);
        int i = 0;
        while (i < this.k) {
            int n = i++;
            posteriori[n] = posteriori[n] / sum;
        }
        return this.labels.valueOf(MathEx.whichMax((double[])posteriori));
    }

    public int[][] test(DataFrame data) {
        DataFrame x = this.formula.x(data);
        int n = x.size();
        int ntrees = this.trees.length;
        int[][] prediction = new int[ntrees][n];
        if (this.k == 2) {
            for (int j = 0; j < n; ++j) {
                Tuple xj = (Tuple)x.get(j);
                double base = 0.0;
                for (int i = 0; i < ntrees; ++i) {
                    prediction[i][j] = (base += this.alpha[i] * (double)this.trees[i].predict(xj)) > 0.0 ? 1 : 0;
                }
            }
        } else {
            double[] p = new double[this.k];
            for (int j = 0; j < n; ++j) {
                Tuple xj = (Tuple)x.get(j);
                Arrays.fill(p, 0.0);
                for (int i = 0; i < ntrees; ++i) {
                    int n2 = this.trees[i].predict(xj);
                    p[n2] = p[n2] + this.alpha[i];
                    prediction[i][j] = MathEx.whichMax((double[])p);
                }
            }
        }
        return prediction;
    }
}

