/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import smile.base.mlp.ActivationFunction;
import smile.base.mlp.Layer;

public class HiddenLayer
extends Layer {
    private static final long serialVersionUID = 2L;
    private ActivationFunction f;

    public HiddenLayer(int n, int p, ActivationFunction f) {
        super(n, p);
        this.f = f;
        this.output = new double[n + 1];
        this.gradient = new double[n + 1];
        this.output[n] = 1.0;
    }

    public String toString() {
        return String.format("%s(%d)", this.f.name(), this.n);
    }

    @Override
    public void f(double[] x) {
        this.f.f(x);
    }

    @Override
    public void backpropagate(double[] error) {
        this.f.g(this.gradient, this.output);
        if (error != null) {
            this.weight.atx(this.gradient, error);
        }
    }
}

