/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Scanner;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.linalg.Transpose;
import smile.math.MathEx;
import smile.tensor.DoubleConsumer;
import smile.tensor.Matrix;
import smile.tensor.ScalarType;
import smile.tensor.Vector;
import smile.util.Strings;

public class SparseMatrix
implements Matrix,
Iterable<Entry>,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(SparseMatrix.class);
    private final int m;
    private final int n;
    private final int[] colIndex;
    private final int[] rowIndex;
    private final double[] nonzeros;

    SparseMatrix() {
        this.m = 0;
        this.n = 0;
        this.rowIndex = null;
        this.colIndex = null;
        this.nonzeros = null;
    }

    private SparseMatrix(int m, int n, int nvals) {
        this.m = m;
        this.n = n;
        this.rowIndex = new int[nvals];
        this.colIndex = new int[n + 1];
        this.nonzeros = new double[nvals];
    }

    public SparseMatrix(int m, int n, double[] nonzeros, int[] rowIndex, int[] colIndex) {
        this.m = m;
        this.n = n;
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        this.nonzeros = nonzeros;
    }

    public SparseMatrix(double[][] A) {
        this(A, 100.0 * MathEx.EPSILON);
    }

    public SparseMatrix(double[][] A, double tol) {
        int j;
        this.m = A.length;
        this.n = A[0].length;
        int nvals = 0;
        for (int i = 0; i < this.m; ++i) {
            for (j = 0; j < this.n; ++j) {
                if (!(Math.abs(A[i][j]) >= tol)) continue;
                ++nvals;
            }
        }
        this.nonzeros = new double[nvals];
        this.rowIndex = new int[nvals];
        this.colIndex = new int[this.n + 1];
        this.colIndex[this.n] = nvals;
        int k = 0;
        for (j = 0; j < this.n; ++j) {
            this.colIndex[j] = k;
            for (int i = 0; i < this.m; ++i) {
                if (!(Math.abs(A[i][j]) >= tol)) continue;
                this.rowIndex[k] = i;
                this.nonzeros[k] = A[i][j];
                ++k;
            }
        }
    }

    @Override
    public SparseMatrix copy() {
        return new SparseMatrix(this.m, this.n, (double[])this.nonzeros.clone(), (int[])this.rowIndex.clone(), (int[])this.colIndex.clone());
    }

    @Override
    public ScalarType scalarType() {
        return ScalarType.Float64;
    }

    @Override
    public int nrow() {
        return this.m;
    }

    @Override
    public int ncol() {
        return this.n;
    }

    @Override
    public long length() {
        return this.colIndex[this.n];
    }

    @Override
    public SparseMatrix scale(double alpha) {
        int i = 0;
        while (i < this.nonzeros.length) {
            int n = i++;
            this.nonzeros[n] = this.nonzeros[n] * alpha;
        }
        return this;
    }

    public Stream<Entry> nonzeros() {
        Spliterator<Entry> spliterator = Spliterators.spliterator(this.iterator(), this.length(), 1104);
        return StreamSupport.stream(spliterator, false);
    }

    public Stream<Entry> nonzeros(int beginColumn, int endColumn) {
        Spliterator<Entry> spliterator = Spliterators.spliterator(this.iterator(beginColumn, endColumn), (long)(this.colIndex[endColumn] - this.colIndex[beginColumn]), 1104);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.iterator(0, this.n);
    }

    public Iterator<Entry> iterator(final int beginColumn, final int endColumn) {
        if (beginColumn < 0 || beginColumn >= this.n) {
            throw new IllegalArgumentException("Invalid begin column: " + beginColumn);
        }
        if (endColumn <= beginColumn || endColumn > this.n) {
            throw new IllegalArgumentException("Invalid end column: " + endColumn);
        }
        return new Iterator<Entry>(this){
            int k;
            int j;
            final /* synthetic */ SparseMatrix this$0;
            {
                SparseMatrix sparseMatrix = this$0;
                Objects.requireNonNull(sparseMatrix);
                this.this$0 = sparseMatrix;
                this.k = this.this$0.colIndex[beginColumn];
                this.j = beginColumn;
            }

            @Override
            public boolean hasNext() {
                return this.k < this.this$0.colIndex[endColumn];
            }

            @Override
            public Entry next() {
                int i = this.this$0.rowIndex[this.k];
                while (this.k >= this.this$0.colIndex[this.j + 1]) {
                    ++this.j;
                }
                return new Entry(this.this$0, i, this.j, this.k++);
            }
        };
    }

    public void forEachNonZero(DoubleConsumer consumer) {
        for (int j = 0; j < this.n; ++j) {
            for (int k = this.colIndex[j]; k < this.colIndex[j + 1]; ++k) {
                int i = this.rowIndex[k];
                consumer.accept(i, j, this.nonzeros[k]);
            }
        }
    }

    public void forEachNonZero(int beginColumn, int endColumn, DoubleConsumer consumer) {
        if (beginColumn < 0 || beginColumn >= this.n) {
            throw new IllegalArgumentException("Invalid begin column: " + beginColumn);
        }
        if (endColumn <= beginColumn || endColumn > this.n) {
            throw new IllegalArgumentException("Invalid end column: " + endColumn);
        }
        for (int j = beginColumn; j < endColumn; ++j) {
            for (int k = this.colIndex[j]; k < this.colIndex[j + 1]; ++k) {
                int i = this.rowIndex[k];
                consumer.accept(i, j, this.nonzeros[k]);
            }
        }
    }

    public double get(int index) {
        return this.nonzeros[index];
    }

    public void set(int index, double value) {
        this.nonzeros[index] = value;
    }

    @Override
    public double get(int i, int j) {
        if (i < 0 || i >= this.m || j < 0 || j >= this.n) {
            throw new IllegalArgumentException("Invalid index: row = " + i + " col = " + j);
        }
        for (int k = this.colIndex[j]; k < this.colIndex[j + 1]; ++k) {
            if (this.rowIndex[k] != i) continue;
            return this.nonzeros[k];
        }
        return 0.0;
    }

    @Override
    public void set(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sub(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mul(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void div(int i, int j, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mv(Transpose trans, double alpha, Vector x, double beta, Vector y) {
        int i;
        int k = trans == Transpose.NO_TRANSPOSE ? this.m : this.n;
        double[] ax = new double[y.size()];
        if (trans == Transpose.NO_TRANSPOSE) {
            for (int j = 0; j < this.n; ++j) {
                for (int i2 = this.colIndex[j]; i2 < this.colIndex[j + 1]; ++i2) {
                    int n = this.rowIndex[i2];
                    ax[n] = ax[n] + this.nonzeros[i2] * x.get(j);
                }
            }
        } else {
            for (i = 0; i < this.n; ++i) {
                for (int j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                    int n = i;
                    ax[n] = ax[n] + this.nonzeros[j] * x.get(this.rowIndex[j]);
                }
            }
        }
        for (i = 0; i < k; ++i) {
            y.set(i, alpha * ax[i] + beta * y.get(i));
        }
    }

    @Override
    public void mv(Vector work, int inputOffset, int outputOffset) {
        work.fill(outputOffset, outputOffset + this.m, 0.0);
        for (int j = 0; j < this.n; ++j) {
            for (int i = this.colIndex[j]; i < this.colIndex[j + 1]; ++i) {
                work.add(outputOffset + this.rowIndex[i], this.nonzeros[i] * work.get(inputOffset + j));
            }
        }
    }

    @Override
    public void tv(Vector work, int inputOffset, int outputOffset) {
        work.fill(outputOffset, outputOffset + this.n, 0.0);
        for (int i = 0; i < this.n; ++i) {
            for (int j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                work.add(outputOffset + i, this.nonzeros[j] * work.get(inputOffset + this.rowIndex[j]));
            }
        }
    }

    @Override
    public SparseMatrix transpose() {
        int k;
        int j;
        int i;
        SparseMatrix trans = new SparseMatrix(this.n, this.m, this.nonzeros.length);
        int[] count = new int[this.m];
        for (i = 0; i < this.n; ++i) {
            for (j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                int n = k = this.rowIndex[j];
                count[n] = count[n] + 1;
            }
        }
        for (int j2 = 0; j2 < this.m; ++j2) {
            trans.colIndex[j2 + 1] = trans.colIndex[j2] + count[j2];
        }
        Arrays.fill(count, 0);
        for (i = 0; i < this.n; ++i) {
            for (j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                k = this.rowIndex[j];
                int index = trans.colIndex[k] + count[k];
                trans.rowIndex[index] = i;
                trans.nonzeros[index] = this.nonzeros[j];
                int n = k;
                count[n] = count[n] + 1;
            }
        }
        return trans;
    }

    public SparseMatrix mm(SparseMatrix B) {
        if (this.n != B.m) {
            throw new IllegalArgumentException(String.format("Matrix dimensions do not match for matrix multiplication: %d x %d vs %d x %d", this.nrow(), this.ncol(), B.nrow(), B.ncol()));
        }
        int n = B.n;
        int anz = this.colIndex[n];
        int[] Bp = B.colIndex;
        int[] Bi = B.rowIndex;
        double[] Bx = B.nonzeros;
        int bnz = Bp[n];
        int[] w = new int[this.m];
        double[] abj = new double[this.m];
        int nzmax = Math.max(anz + bnz, this.m);
        SparseMatrix C = new SparseMatrix(this.m, n, nzmax);
        int[] Cp = C.colIndex;
        int[] Ci = C.rowIndex;
        double[] Cx = C.nonzeros;
        int nz = 0;
        for (int j = 0; j < n; ++j) {
            int p;
            if (nz + this.m > nzmax) {
                nzmax = 2 * nzmax + this.m;
                double[] Cx2 = new double[nzmax];
                int[] Ci2 = new int[nzmax];
                System.arraycopy(Ci, 0, Ci2, 0, nz);
                System.arraycopy(Cx, 0, Cx2, 0, nz);
                Ci = Ci2;
                Cx = Cx2;
                C = new SparseMatrix(this.m, n, Cx2, Ci2, Cp);
            }
            Cp[j] = nz;
            for (p = Bp[j]; p < Bp[j + 1]; ++p) {
                nz = SparseMatrix.scatter(this, Bi[p], Bx[p], w, abj, j + 1, C, nz);
            }
            for (p = Cp[j]; p < nz; ++p) {
                Cx[p] = abj[Ci[p]];
            }
        }
        Cp[n] = nz;
        return C;
    }

    private static int scatter(SparseMatrix A, int j, double beta, int[] w, double[] x, int mark, SparseMatrix C, int nz) {
        int[] Ap = A.colIndex;
        int[] Ai = A.rowIndex;
        double[] Ax = A.nonzeros;
        int[] Ci = C.rowIndex;
        for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
            int i = Ai[p];
            if (w[i] < mark) {
                w[i] = mark;
                Ci[nz++] = i;
                x[i] = beta * Ax[p];
                continue;
            }
            int n = i;
            x[n] = x[n] + beta * Ax[p];
        }
        return nz;
    }

    public SparseMatrix ata() {
        SparseMatrix AT = this.transpose();
        return AT.aat(this);
    }

    public SparseMatrix aat() {
        SparseMatrix AT = this.transpose();
        return this.aat(AT);
    }

    private SparseMatrix aat(SparseMatrix AT) {
        int i;
        int j;
        int i2;
        int[] done = new int[this.m];
        for (int i3 = 0; i3 < this.m; ++i3) {
            done[i3] = -1;
        }
        int nvals = 0;
        for (int j2 = 0; j2 < this.m; ++j2) {
            for (i2 = AT.colIndex[j2]; i2 < AT.colIndex[j2 + 1]; ++i2) {
                int k = AT.rowIndex[i2];
                for (int l = this.colIndex[k]; l < this.colIndex[k + 1]; ++l) {
                    int h = this.rowIndex[l];
                    if (done[h] == j2) continue;
                    done[h] = j2;
                    ++nvals;
                }
            }
        }
        SparseMatrix aat = new SparseMatrix(this.m, this.m, nvals);
        nvals = 0;
        for (i2 = 0; i2 < this.m; ++i2) {
            done[i2] = -1;
        }
        for (j = 0; j < this.m; ++j) {
            aat.colIndex[j] = nvals;
            for (i = AT.colIndex[j]; i < AT.colIndex[j + 1]; ++i) {
                int k = AT.rowIndex[i];
                for (int l = this.colIndex[k]; l < this.colIndex[k + 1]; ++l) {
                    int h = this.rowIndex[l];
                    if (done[h] == j) continue;
                    done[h] = j;
                    aat.rowIndex[nvals] = h;
                    ++nvals;
                }
            }
        }
        aat.colIndex[this.m] = nvals;
        for (j = 0; j < this.m; ++j) {
            if (aat.colIndex[j + 1] - aat.colIndex[j] <= 1) continue;
            Arrays.sort(aat.rowIndex, aat.colIndex[j], aat.colIndex[j + 1]);
        }
        double[] temp = new double[this.m];
        for (i = 0; i < this.m; ++i) {
            int k;
            int j3;
            for (j3 = AT.colIndex[i]; j3 < AT.colIndex[i + 1]; ++j3) {
                k = AT.rowIndex[j3];
                for (int l = this.colIndex[k]; l < this.colIndex[k + 1]; ++l) {
                    int h;
                    int n = h = this.rowIndex[l];
                    temp[n] = temp[n] + AT.nonzeros[j3] * this.nonzeros[l];
                }
            }
            for (j3 = aat.colIndex[i]; j3 < aat.colIndex[i + 1]; ++j3) {
                k = aat.rowIndex[j3];
                aat.nonzeros[j3] = temp[k];
                temp[k] = 0.0;
            }
        }
        return aat;
    }

    @Override
    public Vector diagonal() {
        int n = Math.min(this.nrow(), this.ncol());
        double[] d = new double[n];
        block0: for (int i = 0; i < n; ++i) {
            for (int j = this.colIndex[i]; j < this.colIndex[i + 1]; ++j) {
                if (this.rowIndex[j] != i) continue;
                d[i] = this.nonzeros[j];
                continue block0;
            }
        }
        return Vector.column(d);
    }

    public static SparseMatrix harwell(Path path) throws IOException {
        logger.info("Reads sparse matrix file '{}'", (Object)path.toAbsolutePath());
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            Scanner scanner = new Scanner(stream);
            try {
                int i;
                String line = scanner.nextLine();
                logger.info(line);
                line = scanner.nextLine().trim();
                logger.info(line);
                String[] tokens = line.split("\\s+");
                int RHSCRD = Integer.parseInt(tokens[4]);
                line = scanner.nextLine().trim();
                logger.info(line);
                if (!line.startsWith("R")) {
                    throw new UnsupportedOperationException("SparseMatrix supports only real-valued matrix.");
                }
                tokens = line.split("\\s+");
                int nrow = Integer.parseInt(tokens[1]);
                int ncol = Integer.parseInt(tokens[2]);
                int nz = Integer.parseInt(tokens[3]);
                line = scanner.nextLine();
                logger.info(line);
                if (RHSCRD > 0) {
                    line = scanner.nextLine();
                    logger.info(line);
                }
                int[] colIndex = new int[ncol + 1];
                int[] rowIndex = new int[nz];
                double[] data = new double[nz];
                for (i = 0; i <= ncol; ++i) {
                    colIndex[i] = scanner.nextInt() - 1;
                }
                for (i = 0; i < nz; ++i) {
                    rowIndex[i] = scanner.nextInt() - 1;
                }
                for (i = 0; i < nz; ++i) {
                    data[i] = scanner.nextDouble();
                }
                SparseMatrix sparseMatrix = new SparseMatrix(nrow, ncol, data, rowIndex, colIndex);
                scanner.close();
                return sparseMatrix;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static SparseMatrix rutherford(Path path) throws IOException {
        return SparseMatrix.harwell(path);
    }

    public static SparseMatrix text(Path path) throws IOException {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            Scanner scanner = new Scanner(stream);
            try {
                int i;
                int nrow = scanner.nextInt();
                int ncol = scanner.nextInt();
                int nz = scanner.nextInt();
                int[] colIndex = new int[ncol + 1];
                int[] rowIndex = new int[nz];
                double[] data = new double[nz];
                for (i = 0; i <= ncol; ++i) {
                    colIndex[i] = scanner.nextInt() - 1;
                }
                for (i = 0; i < nz; ++i) {
                    rowIndex[i] = scanner.nextInt() - 1;
                }
                for (i = 0; i < nz; ++i) {
                    data[i] = scanner.nextDouble();
                }
                SparseMatrix sparseMatrix = new SparseMatrix(nrow, ncol, data, rowIndex, colIndex);
                scanner.close();
                return sparseMatrix;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public class Entry {
        public final int i;
        public final int j;
        public final double x;
        public final int index;
        final /* synthetic */ SparseMatrix this$0;

        private Entry(SparseMatrix this$0, int i, int j, int index) {
            SparseMatrix sparseMatrix = this$0;
            Objects.requireNonNull(sparseMatrix);
            this.this$0 = sparseMatrix;
            this.i = i;
            this.j = j;
            this.x = this$0.nonzeros[index];
            this.index = index;
        }

        public void update(double value) {
            this.this$0.nonzeros[this.index] = value;
        }

        public String toString() {
            return String.format("(%d, %d):%s", this.i, this.j, Strings.format(this.x));
        }
    }
}

