/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.Gaussian;
import smile.math.kernel.MercerKernel;

public class BinarySparseGaussianKernel
extends Gaussian
implements MercerKernel<int[]> {
    public BinarySparseGaussianKernel(double sigma) {
        this(sigma, 1.0E-5, 100000.0);
    }

    public BinarySparseGaussianKernel(double sigma, double lo, double hi) {
        super(sigma, lo, hi);
    }

    @Override
    public double k(int[] x, int[] y) {
        return this.k(MathEx.distance(x, y));
    }

    @Override
    public double[] kg(int[] x, int[] y) {
        return this.kg(MathEx.distance(x, y));
    }

    public BinarySparseGaussianKernel of(double[] params) {
        return new BinarySparseGaussianKernel(params[0], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.sigma};
    }

    @Override
    public double[] lo() {
        return new double[]{this.lo};
    }

    @Override
    public double[] hi() {
        return new double[]{this.hi};
    }
}

