/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation2D;

public class ShepardInterpolation2D
implements Interpolation2D {
    private final double[] x1;
    private final double[] x2;
    private final double[] y;
    private final double p;

    public ShepardInterpolation2D(double[] x1, double[] x2, double[] y) {
        this(x1, x2, y, 2.0);
    }

    public ShepardInterpolation2D(double[] x1, double[] x2, double[] y, double p) {
        if (x1.length != x2.length) {
            throw new IllegalArgumentException("x1.length != x2.length");
        }
        if (x1.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        if (p <= 0.0) {
            throw new IllegalArgumentException("Invalid p = " + p);
        }
        this.x1 = x1;
        this.x2 = x2;
        this.y = y;
        this.p = -p;
    }

    @Override
    public double interpolate(double x1, double x2) {
        double weight = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.y.length; ++i) {
            double d1 = x1 - this.x1[i];
            double d2 = x2 - this.x2[i];
            double r = d1 * d1 + d2 * d2;
            if (r == 0.0) {
                return this.y[i];
            }
            double w = Math.pow(r, this.p / 2.0);
            weight += w;
            sum += w * this.y[i];
        }
        return sum / weight;
    }

    public String toString() {
        return String.format("Shepard Interpolation(p = %.4f)", -this.p);
    }
}

