/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.type.StructField;
import smile.data.vector.FloatVector;

class FloatVectorImpl
implements FloatVector {
    private final String name;
    private final Measure measure;
    private final float[] vector;

    public FloatVectorImpl(String name, float[] vector) {
        this.name = name;
        this.measure = null;
        this.vector = vector;
    }

    public FloatVectorImpl(StructField field, float[] vector) {
        if (field.measure instanceof CategoricalMeasure) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.measure = field.measure;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Measure measure() {
        return this.measure;
    }

    @Override
    public float[] array() {
        return this.vector;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public float getFloat(int i) {
        return this.vector[i];
    }

    @Override
    public Float get(int i) {
        return Float.valueOf(this.vector[i]);
    }

    @Override
    public FloatVector get(int ... index) {
        float[] v = new float[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new FloatVectorImpl(this.field(), v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public DoubleStream stream() {
        return IntStream.range(0, this.vector.length).mapToDouble(i -> this.vector[i]);
    }

    public String toString() {
        return this.toString(10);
    }
}

