/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultFileDownloader
implements FileDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDownloader.class);
    private final ProxyConfig proxyConfig;

    public DefaultFileDownloader(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public void download(String downloadUrl, String destination, String userName, String password) throws DownloadException {
        System.setProperty("https.protocols", "TLSv1.2");
        String fixedDownloadUrl = downloadUrl;
        try {
            fixedDownloadUrl = FilenameUtils.separatorsToUnix((String)fixedDownloadUrl);
            URI downloadURI = new URI(fixedDownloadUrl);
            if ("file".equalsIgnoreCase(downloadURI.getScheme())) {
                FileUtils.copyFile((File)new File(downloadURI), (File)new File(destination));
            } else {
                CloseableHttpResponse response = this.execute(fixedDownloadUrl, userName, password);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new DownloadException("Got error code " + statusCode + " from the server.");
                }
                new File(FilenameUtils.getFullPathNoEndSeparator((String)destination)).mkdirs();
                ReadableByteChannel rbc = Channels.newChannel(response.getEntity().getContent());
                FileOutputStream fos = new FileOutputStream(destination);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new DownloadException("Could not download " + fixedDownloadUrl, e);
        }
    }

    private CloseableHttpResponse execute(String requestUrl, String userName, String password) throws IOException {
        CloseableHttpResponse response;
        ProxyConfig.Proxy proxy = this.proxyConfig.getProxyForUrl(requestUrl);
        if (proxy != null) {
            LOGGER.info("Downloading via proxy " + proxy.toString());
            return this.executeViaProxy(proxy, requestUrl);
        }
        LOGGER.info("No proxy was configured, downloading directly");
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)password)) {
            LOGGER.info("Using credentials (" + userName + ") from settings.xml");
            URL aURL = new URL(requestUrl);
            HttpClientContext localContext = this.makeLocalContext(aURL);
            CredentialsProvider credentialsProvider = this.makeCredentialsProvider(aURL.getHost(), aURL.getPort(), userName, password);
            response = this.buildHttpClient(credentialsProvider).execute((HttpUriRequest)new HttpGet(requestUrl), (HttpContext)localContext);
        } else {
            response = this.buildHttpClient(null).execute((HttpUriRequest)new HttpGet(requestUrl));
        }
        return response;
    }

    private CloseableHttpResponse executeViaProxy(ProxyConfig.Proxy proxy, String requestUrl) throws IOException {
        CloseableHttpClient proxyClient = proxy.useAuthentication() ? this.buildHttpClient(this.makeCredentialsProvider(proxy.host, proxy.port, proxy.username, proxy.password)) : this.buildHttpClient(null);
        HttpHost proxyHttpHost = new HttpHost(proxy.host, proxy.port);
        RequestConfig requestConfig = RequestConfig.custom().setProxy(proxyHttpHost).build();
        HttpGet request = new HttpGet(requestUrl);
        request.setConfig(requestConfig);
        return proxyClient.execute((HttpUriRequest)request);
    }

    private CloseableHttpClient buildHttpClient(CredentialsProvider credentialsProvider) {
        return HttpClients.custom().disableContentCompression().useSystemProperties().setDefaultCredentialsProvider(credentialsProvider).build();
    }

    private CredentialsProvider makeCredentialsProvider(String host, int port, String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    private HttpClientContext makeLocalContext(URL requestUrl) {
        HttpHost target = new HttpHost(requestUrl.getHost(), requestUrl.getPort(), requestUrl.getProtocol());
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        return localContext;
    }
}

