/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.LoggerFactory;

@Mojo(name="karma", defaultPhase=LifecyclePhase.TEST)
public final class KarmaRunMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", property="workingDirectory", required=false)
    private File workingDirectory;
    @Parameter(defaultValue="karma.conf.js", property="karmaConfPath")
    private String karmaConfPath;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    private Boolean skipTests;
    @Parameter(property="testFailureIgnore", required=false, defaultValue="false")
    private Boolean testFailureIgnore;
    @Parameter(property="skip.karma", defaultValue="false")
    private Boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip.booleanValue()) {
            try {
                MojoUtils.setSLF4jLogger(this.getLog());
                if (this.skipTests.booleanValue()) {
                    LoggerFactory.getLogger(KarmaRunMojo.class).info("Skipping karma tests.");
                } else {
                    new FrontendPluginFactory(this.workingDirectory).getKarmaRunner().execute("start " + this.karmaConfPath);
                }
            }
            catch (TaskRunnerException e) {
                if (this.testFailureIgnore.booleanValue()) {
                    LoggerFactory.getLogger(KarmaRunMojo.class).warn("There are ignored test failures/errors for: " + this.workingDirectory);
                }
                throw new MojoFailureException("Failed to run task", (Throwable)e);
            }
        }
    }
}

