
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.mzidentml.jaxb.standard;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Data sets generated by the analyses, including peptide and protein lists.
 *
 * <p>Java class for AnalysisDataType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="AnalysisDataType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="SpectrumIdentificationList" type="{http://psidev.info/psi/pi/mzIdentML/1.2}SpectrumIdentificationListType" maxOccurs="unbounded"/>
 *         &lt;element name="ProteinDetectionList" type="{http://psidev.info/psi/pi/mzIdentML/1.2}ProteinDetectionListType" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AnalysisDataType", propOrder = {
    "spectrumIdentificationList",
    "proteinDetectionList"
})
public class AnalysisDataType {

  @XmlElement(name = "SpectrumIdentificationList", required = true)
  protected List<SpectrumIdentificationListType> spectrumIdentificationList;
  @XmlElement(name = "ProteinDetectionList")
  protected ProteinDetectionListType proteinDetectionList;

  /**
   * Gets the value of the spectrumIdentificationList property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the spectrumIdentificationList property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getSpectrumIdentificationList().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link SpectrumIdentificationListType
   * }
   */
  public List<SpectrumIdentificationListType> getSpectrumIdentificationList() {
    if (spectrumIdentificationList == null) {
      spectrumIdentificationList = new ArrayList<SpectrumIdentificationListType>(1);
    }
    return this.spectrumIdentificationList;
  }

  /**
   * Gets the value of the proteinDetectionList property.
   *
   * @return possible object is {@link ProteinDetectionListType }
   */
  public ProteinDetectionListType getProteinDetectionList() {
    return proteinDetectionList;
  }

  /**
   * Sets the value of the proteinDetectionList property.
   *
   * @param value allowed object is {@link ProteinDetectionListType }
   */
  public void setProteinDetectionList(ProteinDetectionListType value) {
    this.proteinDetectionList = value;
  }

}
