package com.franciaflex.magalie.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import javax.persistence.CascadeType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import org.nuiton.jpa.api.AbstractJpaEntity;
import org.nuiton.jpa.api.JpaEntities;
import org.nuiton.jpa.api.JpaEntityIdFactoryResolver;

@Generated(value = "org.nuiton.jpa.templates.JpaEntityTransformer", date = "Wed Sep 11 18:18:21 CEST 2013")
@MappedSuperclass
public abstract class AbstractJpaDeliveredRequestedArticle extends AbstractJpaEntity implements Serializable {

    private static final long serialVersionUID = 7017509137779287090L;

    public static final String PROPERTY_ID = "id";

    public static final String PROPERTY_REQUESTED_ARTICLE = "requestedArticle";

    public static final String PROPERTY_STORAGE_MOVEMENTS = "storageMovements";

    @Id
    protected String id;

    @OneToOne
    protected RequestedArticle requestedArticle;

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    protected Collection<StorageMovement> storageMovements;

    @PrePersist
    public void prePersist() {
        if (this.id == null) {
            this.id = new JpaEntityIdFactoryResolver().newId(this);
        }
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RequestedArticle getRequestedArticle() {
        return requestedArticle;
    }

    public void setRequestedArticle(RequestedArticle requestedArticle) {
        this.requestedArticle = requestedArticle;
    }

    public StorageMovement getStorageMovements(int index) {
        StorageMovement o = getChild(storageMovements, index);
        return o;
    }

    public StorageMovement getStorageMovementsById(String id) {
        StorageMovement o = JpaEntities.findById(storageMovements, id);
        return o;
    }

    public boolean isStorageMovementsEmpty() {
        return storageMovements == null || storageMovements.isEmpty();
    }

    public int sizeStorageMovements() {
        return storageMovements == null ? 0 : storageMovements.size();
    }

    public void addStorageMovements(StorageMovement storageMovements) {
        if (getStorageMovements() == null) {
            setStorageMovements(new ArrayList<StorageMovement>());
        }
        getStorageMovements().add(storageMovements);
    }

    public void addAllStorageMovements(Collection<StorageMovement> storageMovements) {
        if (getStorageMovements() == null) {
            setStorageMovements(new ArrayList<StorageMovement>());
        }
        getStorageMovements().addAll(storageMovements);
    }

    public boolean removeStorageMovements(StorageMovement storageMovements) {
        boolean removed = getStorageMovements() != null && getStorageMovements().remove(storageMovements);
        return removed;
    }

    public boolean removeAllStorageMovements(Collection<StorageMovement> storageMovements) {
        boolean  removed = getStorageMovements() != null && getStorageMovements().removeAll(storageMovements);
        return removed;
    }

    public boolean containsStorageMovements(StorageMovement storageMovements) {
        boolean contains = getStorageMovements() != null && getStorageMovements().contains(storageMovements);
        return contains;
    }

    public boolean containsStorageMovementsById(String id) {
        boolean contains = getStorageMovements() != null && getStorageMovementsById(id) != null;
        return contains;
    }

    public boolean containsAllStorageMovements(Collection<StorageMovement> storageMovements) {
        boolean  contains = getStorageMovements() != null && getStorageMovements().containsAll(storageMovements);
        return contains;
    }

    public Collection<StorageMovement> getStorageMovements() {
        return storageMovements;
    }

    public void setStorageMovements(Collection<StorageMovement> storageMovements) {
        this.storageMovements = storageMovements;
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        T result = null;
        if (childs != null) {
            if (childs instanceof List) {
                if (index < childs.size()) {
                    result = ((List<T>) childs).get(index);
                }
            } else {
                int i = 0;
                for (T o : childs) {
                    if (index == i) {
                        result = o;
                        break;
                    }
                    i++;
                }
            }
        }
        return result;
    }

} //AbstractJpaDeliveredRequestedArticle
