/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.replies.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyContent;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.DemandRepliesUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.DemandRepliesUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.DemandReplyItem;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.Dimension;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.util.MimeMessageUtils;
import org.nuiton.i18n.I18n;

public class OpenReplyAction
extends AbstractFaxToMailAction<DemandeUIModel, DemandRepliesUI, DemandRepliesUIHandler> {
    protected DemandReplyItem item;
    protected ReplyFormUI frameContent;
    protected JFrame frame;

    public OpenReplyAction(DemandRepliesUIHandler handler) {
        super(handler, false);
    }

    public void setItem(DemandReplyItem item) {
        this.item = item;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel demand = (DemandeUIModel)this.getModel();
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        Email email = serviceContext.getEmailService().getFullEmailById(demand.getTopiaId(), this.getContext().getCurrentUser());
        demand.fromEntity(email);
        Reply reply = this.item.getReply();
        FaxToMailUIUtil.forceReplyContentLoading(this.getContext(), reply);
        boolean editable = this.item.isEditable();
        this.frameContent = new ReplyFormUI((FaxToMailUI)this.getUI());
        ReplyContent replyContent = reply.getReplyContent();
        MimeMessage message = MimeMessageUtils.createMimeMessage(null, (byte[])replyContent.getSource());
        ReplyFormUIModel replyModel = this.frameContent.getModel();
        replyModel.setEditable(editable);
        replyModel.setOriginalDemand(demand);
        replyModel.setReadonly(true);
        replyModel.setReadSentDate(reply.getSentDate());
        replyModel.setSubject(message.getSubject());
        replyModel.setTo(StringUtils.join((Object[])message.getRecipients(MimeMessage.RecipientType.TO), (String)" ; "));
        replyModel.setFrom(message.getFrom()[0].toString());
        if (ArrayUtils.isNotEmpty((Object[])message.getRecipients(MimeMessage.RecipientType.CC))) {
            replyModel.setCc(StringUtils.join((Object[])message.getRecipients(MimeMessage.RecipientType.CC), (String)" ; "));
        }
        if (ArrayUtils.isNotEmpty((Object[])message.getRecipients(MimeMessage.RecipientType.BCC))) {
            replyModel.setCci(StringUtils.join((Object[])message.getRecipients(MimeMessage.RecipientType.BCC), (String)" ; "));
        }
        if (message.isMimeType("multipart/*")) {
            ((DemandRepliesUIHandler)this.handler).decomposeMultipartEmail((Part)message, replyModel, reply.getTopiaId());
        } else {
            Charset charset = FaxToMailServiceUtils.getCharset((Part)message);
            String content = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
            replyModel.setMessage(content);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.frame = ((DemandRepliesUIHandler)this.getHandler()).openModalFrame(this.frameContent, I18n.t((String)"faxtomail.reply.title", (Object[])new Object[]{((DemandeUIModel)this.getModel()).getTitle()}), new Dimension(800, 600));
    }

    protected void releaseAction() {
        super.releaseAction();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OpenReplyAction.this.frame != null) {
                    OpenReplyAction.this.frame.toFront();
                    OpenReplyAction.this.frame = null;
                }
            }
        });
    }
}

