/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.ttf.Type1Equivalent;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.ExternalFonts;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType1Equivalent;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.Type1Encoding;
import org.apache.pdfbox.util.Matrix;

public class PDType1CFont
extends PDSimpleFont
implements PDType1Equivalent {
    private static final Log LOG = LogFactory.getLog(PDType1CFont.class);
    private final Map<String, Float> glyphHeights = new HashMap<String, Float>();
    private Float avgWidth = null;
    private Matrix fontMatrix;
    private final AffineTransform fontMatrixTransform;
    private final CFFType1Font cffFont;
    private final Type1Equivalent type1Equivalent;
    private final boolean isEmbedded;
    private final boolean isDamaged;

    public PDType1CFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        PDStream ff3Stream;
        PDFontDescriptor fd = this.getFontDescriptor();
        byte[] bytes = null;
        if (fd != null && (ff3Stream = fd.getFontFile3()) != null && (bytes = IOUtils.toByteArray(ff3Stream.createInputStream())).length == 0) {
            LOG.error((Object)("Invalid data for embedded Type1C font " + this.getName()));
            bytes = null;
        }
        boolean fontIsDamaged = false;
        CFFType1Font cffEmbedded = null;
        try {
            if (bytes != null) {
                CFFParser cffParser = new CFFParser();
                cffEmbedded = (CFFType1Font)cffParser.parse(bytes).get(0);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Can't read the embedded Type1C font " + this.getName()), (Throwable)e);
            fontIsDamaged = true;
        }
        this.isDamaged = fontIsDamaged;
        this.cffFont = cffEmbedded;
        if (this.cffFont != null) {
            this.type1Equivalent = this.cffFont;
            this.isEmbedded = true;
        } else {
            Type1Equivalent t1Equiv = ExternalFonts.getType1EquivalentFont(this.getBaseFont());
            if (t1Equiv != null) {
                this.type1Equivalent = t1Equiv;
            } else {
                this.type1Equivalent = ExternalFonts.getType1FallbackFont(this.getFontDescriptor());
                LOG.warn((Object)("Using fallback font " + this.type1Equivalent.getName() + " for " + this.getBaseFont()));
            }
            this.isEmbedded = false;
        }
        this.readEncoding();
        this.fontMatrixTransform = this.getFontMatrix().createAffineTransform();
        this.fontMatrixTransform.scale(1000.0, 1000.0);
    }

    @Override
    public Type1Equivalent getType1Equivalent() {
        return this.type1Equivalent;
    }

    public String getBaseFont() {
        return this.dict.getNameAsString(COSName.BASE_FONT);
    }

    @Override
    public GeneralPath getPath(String name) throws IOException {
        if (name.equals(".notdef") && !this.isEmbedded() && !this.isStandard14()) {
            return new GeneralPath();
        }
        return this.type1Equivalent.getPath(name);
    }

    @Override
    public String getName() {
        return this.getBaseFont();
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        return this.type1Equivalent.getFontBBox();
    }

    @Override
    public String codeToName(int code) {
        return this.getEncoding().getName(code);
    }

    @Override
    protected Encoding readEncodingFromFont() throws IOException {
        if (this.getStandard14AFM() != null) {
            return new Type1Encoding(this.getStandard14AFM());
        }
        return Type1Encoding.fromFontBox(this.type1Equivalent.getEncoding());
    }

    @Override
    public int readCode(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            List numbers;
            if (this.cffFont != null && (numbers = this.cffFont.getFontMatrix()) != null && numbers.size() == 6) {
                this.fontMatrix = new Matrix(((Number)numbers.get(0)).floatValue(), ((Number)numbers.get(1)).floatValue(), ((Number)numbers.get(2)).floatValue(), ((Number)numbers.get(3)).floatValue(), ((Number)numbers.get(4)).floatValue(), ((Number)numbers.get(5)).floatValue());
                return this.fontMatrix;
            }
            this.fontMatrix = super.getFontMatrix();
        }
        return this.fontMatrix;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        String name = this.codeToName(code);
        float width = this.type1Equivalent.getWidth(name);
        Point2D.Float p = new Point2D.Float(width, 0.0f);
        this.fontMatrixTransform.transform(p, p);
        return (float)((Point2D)p).getX();
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public float getHeight(int code) throws IOException {
        String name = this.codeToName(code);
        float height = 0.0f;
        if (!this.glyphHeights.containsKey(name)) {
            height = (float)this.cffFont.getType1CharString(name).getBounds().getHeight();
            this.glyphHeights.put(name, Float.valueOf(height));
        }
        return height;
    }

    @Override
    protected byte[] encode(int unicode) throws IOException {
        throw new UnsupportedOperationException("Not implemented: Type1C");
    }

    @Override
    public float getStringWidth(String string) throws IOException {
        float width = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            int codePoint = string.codePointAt(i);
            String name = this.getGlyphList().codePointToName(codePoint);
            width += (float)this.cffFont.getType1CharString(name).getWidth();
        }
        return width;
    }

    @Override
    public float getAverageFontWidth() {
        if (this.avgWidth == null) {
            this.avgWidth = Float.valueOf(this.getAverageCharacterWidth());
        }
        return this.avgWidth.floatValue();
    }

    public CFFType1Font getCFFType1Font() {
        return this.cffFont;
    }

    private float getAverageCharacterWidth() {
        return 500.0f;
    }
}

