/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.service.ldap.Contact;
import com.franciaflex.faxtomail.ui.swing.actions.AddAttachmentToReplyAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.AttachmentItem;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyAttachmentModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.util.Cancelable;

public class ReplyFormUIHandler
extends AbstractFaxToMailUIHandler<ReplyFormUIModel, ReplyFormUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(ReplyFormUIHandler.class);
    protected AddAttachmentToReplyAction addAttachmentToReplyAction;

    public void beforeInit(ReplyFormUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.addAttachmentToReplyAction = (AddAttachmentToReplyAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, AddAttachmentToReplyAction.class);
        ReplyFormUIModel model = new ReplyFormUIModel();
        long maxSize = this.getContext().newServiceContext().getConfigurationService().getEmailMaxSize();
        model.setMaxAttachmentLength(maxSize);
        ((ReplyFormUI)this.ui).setContextValue(model);
    }

    public void afterInit(ReplyFormUI replyFormUI) {
        this.initUI(this.ui);
        JTextPane editor = ((ReplyFormUI)this.ui).getMessage();
        editor.setCaretPosition(0);
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        model.addPropertyChangeListener("originalDemand", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DemandeUIModel demand = (DemandeUIModel)evt.getNewValue();
                ReplyFormUIModel model = (ReplyFormUIModel)((Object)evt.getSource());
                ArrayList<DemandeUIModel> models = new ArrayList<DemandeUIModel>();
                models.addAll(demand.getGroupedDemandes());
                for (DemandeUIModel demandeUIModel : models) {
                    String prefix = StringUtils.remove((String)demandeUIModel.getTitle(), (char)'\n');
                    for (Attachment attachment : demandeUIModel.getAttachment()) {
                        ReplyAttachmentModel replyOriginalAttachmentModel = new ReplyAttachmentModel(attachment, true, prefix + attachment.getOriginalFileName());
                        model.addAvailableAttachment(replyOriginalAttachmentModel);
                        if (Strings.isNullOrEmpty((String)attachment.getEditedFileName())) continue;
                        ReplyAttachmentModel replyEditedAttachmentModel = new ReplyAttachmentModel(attachment, false, prefix + attachment.getEditedFileName());
                        model.addAvailableAttachment(replyEditedAttachmentModel);
                    }
                }
                model.setSubject(I18n.t((String)"faxtomail.reply.subject", (Object[])new Object[]{demand.getSubject()}));
                String plainContent = JAXXUtil.getStringValue((Object)demand.getPlainContent());
                String quotedReply = I18n.t((String)"faxtomail.reply.message", (Object[])new Object[]{ReplyFormUIHandler.this.decorate(demand.getReceptionDate()), demand.getSender(), plainContent.replaceAll("\n", "\n> ")});
                model.setMessage(quotedReply);
                String recipient = demand.getRecipient();
                if (!model.isReadonly()) {
                    JComboBox addAttachmentFile = ((ReplyFormUI)ReplyFormUIHandler.this.ui).getAddAttachmentFile();
                    addAttachmentFile.setModel(SwingUtil.newComboModel((Object[])model.getAvailableAttachments().toArray()));
                    addAttachmentFile.setSelectedItem(null);
                    ArrayList<String> folderReplyAdresses = new ArrayList<String>();
                    ArrayList<String> folderReplyDomains = new ArrayList<String>();
                    for (MailFolder folder = demand.getMailFolder(); folder != null; folder = folder.getParent()) {
                        folderReplyAdresses.addAll(folder.getReplyAddresses());
                        folderReplyDomains.addAll(folder.getReplyDomains());
                    }
                    model.setSenderAllowedDomains(folderReplyDomains);
                    ArrayList replyToAddresses = Lists.newArrayList();
                    String selectedItem = null;
                    if (!demand.isFax() && recipient != null) {
                        replyToAddresses.add(recipient);
                        model.setFrom(recipient);
                        selectedItem = recipient;
                    }
                    if (folderReplyAdresses != null) {
                        replyToAddresses.addAll(folderReplyAdresses);
                    }
                    Collections.sort(replyToAddresses);
                    DefaultComboBoxModel comboBoxModel = SwingUtil.newComboModel((Object[])replyToAddresses.toArray());
                    comboBoxModel.setSelectedItem(selectedItem);
                    ((ReplyFormUI)ReplyFormUIHandler.this.ui).getFromComboBox().setModel(comboBoxModel);
                    model.setSenderAllowedAddresses(replyToAddresses);
                    ReplyFormUIHandler.this.initBeanFilterableComboBox(((ReplyFormUI)ReplyFormUIHandler.this.ui).getContactField(), ReplyFormUIHandler.this.getContext().getContactCache(), null);
                } else {
                    model.setFrom(recipient);
                }
            }
        });
        model.addPropertyChangeListener("attachment", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReplyFormUIHandler.this.updateAttachmentPanel((Collection)evt.getNewValue());
            }
        });
        model.addPropertyChangeListener("readonly", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReplyFormUIHandler.this.updateAttachmentPanel(((ReplyFormUIModel)((Object)ReplyFormUIHandler.this.getModel())).getAttachments());
            }
        });
        JComboBox addAttachmentFile = ((ReplyFormUI)this.ui).getAddAttachmentFile();
        addAttachmentFile.setEditor(new FileComboBoxEditor());
        this.getValidator().addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReplyFormUIModel model = (ReplyFormUIModel)((Object)ReplyFormUIHandler.this.getModel());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + evt.getNewValue() + "]"));
                }
                model.setValid((Boolean)evt.getNewValue());
            }
        });
    }

    public void cancel() {
        this.closeFrame();
    }

    public void onCloseUI() {
    }

    public SwingValidator<ReplyFormUIModel> getValidator() {
        return ((ReplyFormUI)this.getUI()).getValidator();
    }

    protected JComponent getComponentToFocus() {
        return ((ReplyFormUI)this.getUI()).getMessage();
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }

    public void removeAttachment(ReplyAttachmentModel attachment) {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        model.removeAttachment(attachment);
        model.addAvailableAttachment(attachment);
        ((ReplyFormUI)this.ui).getAddAttachmentFile().addItem(attachment);
    }

    public void addAttachment() {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        JComboBox addAttachmentFile = ((ReplyFormUI)this.ui).getAddAttachmentFile();
        ReplyAttachmentModel replyAttachmentModel = null;
        Object selectedItem = addAttachmentFile.getSelectedItem();
        if (ReplyAttachmentModel.class.isAssignableFrom(selectedItem.getClass())) {
            replyAttachmentModel = (ReplyAttachmentModel)selectedItem;
            this.addAttachmentToReplyAction.setReplyAttachmentModel(replyAttachmentModel);
            this.getContext().getActionEngine().runActionAndWait((AbstractApplicationAction)this.addAttachmentToReplyAction);
        } else if (File.class.isAssignableFrom(selectedItem.getClass())) {
            String fileName;
            AttachmentFileImpl attachmentFile;
            block6: {
                File file = (File)selectedItem;
                attachmentFile = new AttachmentFileImpl();
                fileName = file.getName();
                attachmentFile.setFilename(fileName);
                try {
                    attachmentFile.setContent(FileUtils.readFileToByteArray((File)file));
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)("Error while converting the file " + fileName + " into a byte[]"), (Throwable)e);
                }
            }
            AttachmentImpl attachment = new AttachmentImpl();
            attachment.setOriginalFile(attachmentFile);
            replyAttachmentModel = new ReplyAttachmentModel(attachment, true, fileName);
        }
        if (replyAttachmentModel != null) {
            model.addAttachment(replyAttachmentModel);
            model.removeAvailableAttachment(replyAttachmentModel);
            ((ReplyFormUI)this.ui).getAddAttachmentFile().removeItem(replyAttachmentModel);
            addAttachmentFile.setSelectedItem(null);
        }
    }

    protected void updateAttachmentPanel(Collection<ReplyAttachmentModel> attachments) {
        JPanel attachmentsPanel = ((ReplyFormUI)this.ui).getAttachmentsPanel();
        attachmentsPanel.removeAll();
        for (ReplyAttachmentModel attachment : attachments) {
            AttachmentItem item = new AttachmentItem();
            item.setHandler(this);
            item.setReplyAttachmentModel(attachment);
            attachmentsPanel.add(item);
        }
        attachmentsPanel.updateUI();
    }

    public void openLocation() {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        File startFile = model.getLastVisitedDirectory();
        JFileChooser fc = new JFileChooser(startFile);
        fc.setFileSelectionMode(0);
        int returnVal = fc.showOpenDialog((Component)this.ui);
        model.setLastVisitedDirectory(fc.getCurrentDirectory());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            ((ReplyFormUI)this.ui).getAddAttachmentFile().setSelectedItem(file);
        }
    }

    public void openAttachment(ReplyAttachmentModel attachment) {
        FaxToMailUIUtil.openFile(this.getContext(), attachment.getAttachmentFile());
    }

    public void forward() {
        this.closeFrame();
        try {
            ReplyFormUI dialogContent = new ReplyFormUI((FaxToMailUI)this.ui);
            ReplyFormUIModel replyModel = dialogContent.getModel();
            replyModel.fromModel(((ReplyFormUI)this.ui).getModel());
            String quotedReply = I18n.t((String)"faxtomail.reply.message", (Object[])new Object[]{this.decorate(replyModel.getReadSentDate()), replyModel.getFrom(), replyModel.getMessage().replaceAll("\n", "\n> ")});
            replyModel.setMessage(quotedReply);
            replyModel.setSubject(I18n.t((String)"faxtomail.reply.forwardsubject", (Object[])new Object[]{replyModel.getSubject()}));
            replyModel.setReadonly(false);
            replyModel.setOriginalDemand(((ReplyFormUIModel)((Object)this.getModel())).getOriginalDemand());
            replyModel.setReadSentDate(null);
            replyModel.setTo(null);
            replyModel.setCc(null);
            replyModel.setCci(null);
            this.openModalFrame(dialogContent, I18n.t((String)"faxtomail.reply.forward", (Object[])new Object[]{((ReplyFormUIModel)((Object)this.getModel())).getSubject()}), new Dimension(800, 600));
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't display forward frame", (Throwable)ex);
            }
            this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.demandReplies.error", (Object[])new Object[0]), (Throwable)ex);
        }
    }

    public void addTo() {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        Contact contact = model.getContact();
        if (contact != null) {
            String to = model.getTo();
            String email = contact.getEmail();
            to = StringUtils.isNotBlank((CharSequence)to) ? to + ";" + email : email;
            model.setTo(to);
        }
    }

    public void addCc() {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        Contact contact = model.getContact();
        if (contact != null) {
            String cc = model.getCc();
            String email = contact.getEmail();
            cc = StringUtils.isNotBlank((CharSequence)cc) ? cc + ";" + email : email;
            model.setCc(cc);
        }
    }

    public void addCci() {
        ReplyFormUIModel model = (ReplyFormUIModel)((Object)this.getModel());
        Contact contact = model.getContact();
        if (contact != null) {
            String cci = model.getCci();
            String email = contact.getEmail();
            cci = StringUtils.isNotBlank((CharSequence)cci) ? cci + ";" + email : email;
            model.setCci(cci);
        }
    }

    protected class FileComboBoxEditor
    implements ComboBoxEditor {
        protected ReplyAttachmentModel oldValue;
        protected JTextField editorComponent = new JTextField();

        protected FileComboBoxEditor() {
        }

        @Override
        public Component getEditorComponent() {
            return this.editorComponent;
        }

        @Override
        public void setItem(Object anObject) {
            String text;
            ReplyAttachmentModel replyAttachmentModel = null;
            if (anObject != null) {
                if (ReplyAttachmentModel.class.isAssignableFrom(anObject.getClass())) {
                    replyAttachmentModel = (ReplyAttachmentModel)anObject;
                } else if (File.class.isAssignableFrom(anObject.getClass())) {
                    File file = (File)anObject;
                    AttachmentFileImpl attachmentFile = new AttachmentFileImpl();
                    String fileName = file.getName();
                    attachmentFile.setFilename(fileName);
                    replyAttachmentModel = new ReplyAttachmentModel(new AttachmentImpl(), true, fileName);
                }
            }
            if (replyAttachmentModel != null) {
                text = replyAttachmentModel.getLabel();
                this.oldValue = replyAttachmentModel;
            } else {
                text = "";
            }
            if (!text.equals(this.editorComponent.getText())) {
                this.editorComponent.setText(text);
            }
        }

        @Override
        public Object getItem() {
            Object newValue = this.editorComponent.getText();
            if (this.oldValue != null) {
                if (newValue.equals(this.oldValue.getLabel())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke((Object)this.oldValue, this.editorComponent.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        @Override
        public void selectAll() {
            this.editorComponent.selectAll();
            this.editorComponent.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editorComponent.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editorComponent.removeActionListener(l);
        }
    }
}

