/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JImagePanel
extends JPanel {
    private static final Log log = LogFactory.getLog(JImagePanel.class);
    protected Image image;
    protected Image scaledImage;
    protected int rotation = 0;
    protected boolean scaleImageToFitPanel;
    protected ComponentAdapter resizeAdapter = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            Component component = e.getComponent();
            if (JImagePanel.this.image != null) {
                int srcWidth = component.getWidth();
                int srcHeight = component.getHeight();
                int newWidth = JImagePanel.this.rotation % 180 == 0 ? srcWidth : srcHeight;
                int newHeight = JImagePanel.this.rotation % 180 == 0 ? srcHeight : srcWidth;
                JImagePanel.this.scaledImage = JImagePanel.this.image.getScaledInstance(newWidth, newHeight, 4);
            }
            JImagePanel.this.repaint();
        }
    };

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isScaleImageToFitPanel() {
        return this.scaleImageToFitPanel;
    }

    public void setScaleImageToFitPanel(boolean scaleImageToFitPanel) {
        if (this.scaleImageToFitPanel != scaleImageToFitPanel) {
            if (scaleImageToFitPanel) {
                this.addComponentListener(this.resizeAdapter);
            } else {
                this.removeComponentListener(this.resizeAdapter);
            }
        }
        this.scaleImageToFitPanel = scaleImageToFitPanel;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getScaledImage() {
        return this.scaledImage;
    }

    public void setImage(File img) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(img);
        }
        catch (IOException e) {
            log.error((Object)("error while reading image " + img.getAbsolutePath()), (Throwable)e);
            bufferedImage = null;
        }
        if (bufferedImage != null) {
            this.setImage(bufferedImage);
        }
    }

    public void setImage(Image img) {
        this.image = img;
        this.scaledImage = img;
        int srcWidth = img.getWidth(null);
        int srcHeight = img.getHeight(null);
        int newWidth = this.rotation % 180 == 0 ? srcWidth : srcHeight;
        int newHeight = this.rotation % 180 == 0 ? srcHeight : srcWidth;
        Dimension size = new Dimension(newWidth, newHeight);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
    }

    public void setImage(String img) {
        this.setImage(new ImageIcon(img).getImage());
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.scaledImage != null) {
            double translateY;
            double translateX;
            Graphics2D g2d = (Graphics2D)g;
            double width = this.getSize().getWidth();
            double height = this.getSize().getHeight();
            switch (this.rotation) {
                case 90: {
                    translateX = width;
                    translateY = 0.0;
                    break;
                }
                case 180: {
                    translateX = width;
                    translateY = height;
                    break;
                }
                case 270: {
                    translateX = 0.0;
                    translateY = height;
                    break;
                }
                default: {
                    translateX = 0.0;
                    translateY = 0.0;
                }
            }
            g2d.translate(translateX, translateY);
            g2d.rotate(Math.toRadians(this.rotation), 0.0, 0.0);
            Insets insets = this.getInsets();
            int leftInset = this.rotation % 180 == 0 ? insets.left : insets.top;
            int topInset = this.rotation % 180 == 0 ? insets.top : insets.left;
            g2d.drawImage(this.scaledImage, leftInset, topInset, this);
        }
    }
}

