/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class GridFlowLayout
implements LayoutManager2 {
    protected Map<Component, Object> positions = new HashMap<Component, Object>();
    int hgap;
    int vgap;

    public GridFlowLayout() {
        this(1, 1);
    }

    public GridFlowLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Number) {
            this.positions.put(comp, constraints);
        }
    }

    public void setConstraints(Component comp, Number constraints) {
        this.positions.put(comp, constraints);
    }

    public Number getConstraints(Component comp) {
        return (Number)this.positions.get(comp);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return this.getMinWidthHeight(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension result = this.getMaxWidthHeight(parent);
            Insets insets = parent.getInsets();
            int nbChild = this.getComponentVisibleCount(parent);
            int nbColumn = (int)Math.round(Math.sqrt(nbChild));
            for (Container container = parent; container != null && container.getWidth() != 0; container = container.getParent()) {
                if (!(container instanceof JViewport)) continue;
                nbColumn = (container.getWidth() - insets.left - insets.right) / ((int)result.getWidth() + 2 * this.hgap);
                break;
            }
            if (nbColumn == 0) {
                ++nbColumn;
            }
            int nbRow = (int)Math.ceil((double)nbChild / (double)nbColumn);
            result.width *= nbColumn;
            result.height *= nbRow;
            result.width += this.hgap * 2 * nbColumn;
            result.height += this.vgap * 2 * nbRow;
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
            return result;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.positions.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] components = parent.getComponents();
            if (components.length == 0) {
                return;
            }
            components = this.computeOrder(components);
            Dimension max = this.getMaxWidthHeight(parent);
            int w = (int)max.getWidth();
            int h = (int)max.getHeight();
            Insets insets = parent.getInsets();
            int parentWidth = parent.getWidth();
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            int nbColumn = (parentWidth - insets.left - insets.right) / (w + 2 * this.hgap);
            if (nbColumn == 0) {
                ++nbColumn;
            }
            w = (parentWidth - insets.left - insets.right) / nbColumn;
            w -= 2 * this.hgap;
            int ltrNb = 0;
            int horizontalMargin = insets.left;
            int verticalMargin = insets.top;
            if (!ltr) {
                ltrNb = nbColumn - 1;
                horizontalMargin = insets.right;
            }
            int count = 0;
            for (Component component : components) {
                if (!component.isVisible()) continue;
                int column = count % nbColumn;
                int row = count / nbColumn;
                component.setBounds(Math.abs(ltrNb - column) * w + horizontalMargin + (2 * column + 1) * this.hgap, row * h + verticalMargin + (2 * row + 1) * this.vgap, w, h);
                ++count;
            }
        }
    }

    protected int getComponentVisibleCount(Container parent) {
        Component[] components;
        int result = 0;
        for (Component component : components = parent.getComponents()) {
            if (!component.isVisible()) continue;
            ++result;
        }
        return result;
    }

    protected Dimension getMaxWidthHeight(Container parent) {
        Component[] components = parent.getComponents();
        Dimension result = new Dimension(0, 0);
        for (Component component : components) {
            if (!component.isVisible()) continue;
            Dimension d = component.getPreferredSize();
            result.width = Math.max(result.width, d.width);
            result.height = Math.max(result.height, d.height);
        }
        return result;
    }

    protected Dimension getMinWidthHeight(Container parent) {
        Component[] components = parent.getComponents();
        Dimension result = new Dimension(0, 0);
        for (Component component : components) {
            if (!component.isVisible()) continue;
            Dimension d = component.getMinimumSize();
            result.width = Math.max(result.width, d.width);
            result.height = Math.max(result.height, d.height);
        }
        return result;
    }

    public Component[] computeOrder(Component[] components) {
        Component[] result = new Component[components.length];
        HashSet<Component> inWait = new HashSet<Component>();
        for (Component comp : this.positions.keySet()) {
            Number pos = (Number)this.positions.get(comp);
            if (pos != null && -1 < pos.intValue() && pos.intValue() < result.length) {
                result[pos.intValue()] = comp;
                continue;
            }
            inWait.add(comp);
        }
        int j = 0;
        for (Component component : components) {
            if (!inWait.contains(component) && this.positions.containsKey(component)) continue;
            while (result[j] != null) {
                ++j;
            }
            result[j] = component;
        }
        return result;
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(new GridFlowLayout(10, 5));
        for (int i = 0; i < 10; ++i) {
            panel.add((Component)new JButton("label " + i), new Integer(i + 3));
        }
        JFrame frame = new JFrame("Test");
        frame.getContentPane().add(new JScrollPane(panel));
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }
}

