/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.DecodeException;
import com.twelvemonkeys.io.enc.Decoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class PackBits16Decoder
implements Decoder {
    private final boolean disableNoop;
    private int leftOfRun;
    private boolean splitRun;
    private boolean reachedEOF;

    public PackBits16Decoder() {
        this(false);
    }

    public PackBits16Decoder(boolean bl) {
        this.disableNoop = bl;
    }

    public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        if (this.reachedEOF) {
            return -1;
        }
        int n = 0;
        int n2 = byteBuffer.capacity();
        while (n < n2) {
            int n3;
            int n4;
            if (this.splitRun) {
                n4 = this.leftOfRun;
                this.splitRun = false;
            } else {
                n3 = inputStream.read();
                if (n3 < 0) {
                    this.reachedEOF = true;
                    break;
                }
                n4 = (byte)n3;
            }
            if (n4 >= 0 && 2 * (n4 + 1) + n > n2) {
                this.leftOfRun = n4;
                this.splitRun = true;
                break;
            }
            if (n4 < 0 && 2 * (-n4 + 1) + n > n2) {
                this.leftOfRun = n4;
                this.splitRun = true;
                break;
            }
            try {
                if (n4 >= 0) {
                    n3 = 2 * (n4 + 1);
                    PackBits16Decoder.readFully(inputStream, byteBuffer, n3);
                    n += n3;
                    continue;
                }
                if (!this.disableNoop && n4 == -128) continue;
                n3 = PackBits16Decoder.readByte(inputStream);
                byte by = PackBits16Decoder.readByte(inputStream);
                for (int i = -n4 + 1; i > 0; --i) {
                    byteBuffer.put((byte)n3);
                    byteBuffer.put(by);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new DecodeException("Error in PackBits decompression, data seems corrupt", indexOutOfBoundsException);
            }
        }
        return n;
    }

    private static byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException("Unexpected end of PackBits stream");
        }
        return (byte)n;
    }

    private static void readFully(InputStream inputStream, ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException("Unexpected end of PackBits stream");
        }
    }
}

