/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.AbstractFaxToMailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.AttachmentTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EdiReturn;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.EmailGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.ExtensionCommand;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.MailFolderTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailLock;
import com.franciaflex.faxtomail.persistence.entities.MailLockImpl;
import com.franciaflex.faxtomail.persistence.entities.MailLockTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmail;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.PriorityTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.RangeRowTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.RangeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.persistence.entities.ReplyContent;
import com.franciaflex.faxtomail.persistence.entities.ReplyContentTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.ReplyTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.SearchFilter;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.persistence.entities.WaitingStateTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.services.service.exceptions.AlreadyLockedMailException;
import com.franciaflex.faxtomail.services.service.exceptions.FolderNotReadableException;
import com.franciaflex.faxtomail.services.service.exceptions.InvalidClientException;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportExportBean;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportExportModel;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportResult;
import com.franciaflex.faxtomail.services.service.imports.InvalidArchiveImportBeanException;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import gui.ava.html.Html2Image;
import gui.ava.html.renderer.ImageRenderer;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaQueryException;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.support.TopiaSqlWork;
import org.nuiton.util.StringUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class EmailServiceImpl
extends FaxToMailServiceSupport
implements EmailService {
    private static final Log log = LogFactory.getLog(EmailServiceImpl.class);
    protected Binder<Attachment, Attachment> attachmentBinder = BinderFactory.newBinder(Attachment.class, Attachment.class);

    @Override
    public Email getEmailById(String id) {
        Email email = (Email)this.getPersistenceContext().getEmailDao().forTopiaIdEquals(id).findUnique();
        return email;
    }

    protected Email getEmailById(String id, String fetch, String ... otherFetches) {
        Email email = (Email)this.getPersistenceContext().getEmailDao().forTopiaIdEquals(id).addAllFetches(fetch, otherFetches).findUnique();
        return email;
    }

    @Override
    public Email getFullEmailById(String id) {
        EmailGroup emailGroup;
        Email email = (Email)this.getPersistenceContext().getEmailDao().forTopiaIdEquals(id).addAllFetches("demandType", new String[]{"takenBy", "lastAttachmentOpener", "client", "waitingState", "originalEmail", "priority"}).findUnique();
        List rangeRows = email.getRangeRow();
        if (rangeRows != null) {
            for (RangeRow rangeRow : rangeRows) {
                Hibernate.initialize((Object)rangeRow.getRange());
            }
        }
        Hibernate.initialize((Object)email.getReplies());
        Hibernate.initialize((Object)email.getAttachment());
        Collection histories = email.getHistory();
        if (histories != null) {
            for (History history : histories) {
                Hibernate.initialize((Object)history.getFaxToMailUser());
            }
        }
        if ((emailGroup = email.getEmailGroup()) != null) {
            Set emails = emailGroup.getEmail();
            for (Email email2 : emails) {
                Hibernate.initialize((Object)email2.getMailFolder());
                Hibernate.initialize((Object)email2.getAttachment());
            }
        }
        return email;
    }

    @Override
    public Email getFullEmailById(String id, FaxToMailUser user) {
        Email email = this.getFullEmailById(id);
        MailFolderService mailFolderService = this.serviceContext.getMailFolderService();
        MailFolder folder = email.getMailFolder();
        this.browseFolderParent(folder, user, mailFolderService);
        return email;
    }

    protected void browseFolderParent(MailFolder folder, FaxToMailUser user, MailFolderService mailFolderService) {
        boolean readable;
        boolean writable;
        Hibernate.initialize((Object)folder);
        mailFolderService.fetchFolderAttributes(folder);
        MailFolder parent = folder.getParent();
        if (parent != null) {
            this.browseFolderParent(parent, user, mailFolderService);
        }
        boolean bl = writable = parent != null && parent.isFolderWritable();
        if (folder.getWriteRightGroups() != null && user.getUserGroups() != null) {
            writable |= CollectionUtils.containsAny((Collection)folder.getWriteRightGroups(), (Collection)user.getUserGroups());
        }
        writable |= folder.containsWriteRightUsers(user);
        boolean bl2 = readable = parent != null && parent.isFolderReadable();
        if (folder.getReadRightGroups() != null && user.getUserGroups() != null) {
            readable |= CollectionUtils.containsAny((Collection)folder.getReadRightGroups(), (Collection)user.getUserGroups());
        }
        folder.setFolderWritable(writable);
        folder.setFolderReadable(readable |= folder.containsReadRightUsers(user));
    }

    @Override
    public Email saveEmail(Email email, FaxToMailUser user, String ... modifiedFields) throws InvalidClientException {
        Client client = email.getClient();
        return this.saveEmail(email, null, email.getReplies(), client != null ? client.getCode() : null, user, modifiedFields);
    }

    @Override
    public Email saveEmail(Email email, Collection<Attachment> attachments, Collection<Reply> replies, String clientCode, FaxToMailUser user, String ... modifiedFields) throws InvalidClientException {
        Collection histories;
        OriginalEmail originalEmail;
        Date now = this.getNow();
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        MailFolder folder = email.getMailFolder();
        while (!folder.isUseCurrentLevelCompany() && folder.getParent() != null) {
            folder = folder.getParent();
        }
        String company = folder.getCompany();
        Client client = null;
        if (StringUtils.isNotBlank((CharSequence)clientCode)) {
            Client emailClient = email.getClient();
            if (emailClient != null && clientCode.equals(email.getClient().getCode())) {
                client = emailClient;
            } else {
                client = this.getClientService().getClientForCode(clientCode, company);
                if (client == null) {
                    String message = I18n.t((String)"faxtomail.service.email.save.clientCode.error", (Object[])new Object[]{clientCode});
                    throw new InvalidClientException(message);
                }
            }
        }
        email.setClient(client);
        if (attachments != null) {
            this.updateAttachments(email, attachments, user);
        }
        if (replies != null) {
            this.updateReplies(email);
        }
        if (email.getRangeRow() != null) {
            RangeRowTopiaDao rangeRowDao = this.getPersistenceContext().getRangeRowDao();
            for (RangeRow rangeRow : email.getRangeRow()) {
                if (!rangeRow.isPersisted()) {
                    rangeRowDao.create((TopiaEntity)rangeRow);
                    continue;
                }
                rangeRowDao.update((TopiaEntity)rangeRow);
            }
        }
        if (!(originalEmail = email.getOriginalEmail()).isPersisted()) {
            this.getPersistenceContext().getOriginalEmailDao().create((TopiaEntity)originalEmail);
        }
        if (!email.isPersisted()) {
            histories = email.getHistory();
            if (histories != null) {
                historyDao.createAll((Iterable)histories);
            }
            email = (Email)dao.create((TopiaEntity)email);
        } else {
            histories = historyDao.forEquals("email.topiaId", (Object)email.getTopiaId()).findAll();
        }
        HashSet fieldSet = Sets.newHashSet((Object[])modifiedFields);
        History transmissionToEdi = (History)CollectionUtils.find((Iterable)histories, (org.apache.commons.collections4.Predicate)new org.apache.commons.collections4.Predicate<History>(){

            public boolean evaluate(History object) {
                return object.getType() == HistoryType.TRANSMISSION_TO_EDI;
            }
        });
        if (transmissionToEdi == null && email.getClient() != null && email.getDemandType() != null && StringUtils.isNotBlank((CharSequence)email.getProjectReference())) {
            this.handleEdiTransmission(email, historyDao, fieldSet);
        }
        if (histories != null) {
            historyDao.createAll((Iterable)Collections2.filter((Collection)histories, (Predicate)new Predicate<History>(){

                public boolean apply(History history) {
                    return !history.isPersisted();
                }
            }));
        }
        History history = null;
        if (fieldSet.contains("archiveDate")) {
            history = (History)historyDao.create("type", (Object)HistoryType.ARCHIVED, new Object[]{"faxToMailUser", user, "modificationDate", now, "email", email});
        } else if (fieldSet.contains("mailFolder")) {
            history = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION, new Object[]{"faxToMailUser", user, "modificationDate", now, "email", email});
        } else {
            boolean historyEmpty;
            if (email.getTakenBy() == null && !fieldSet.isEmpty() && !fieldSet.contains("takenBy")) {
                email.setTakenBy(user);
                fieldSet.add("takenBy");
            }
            if ((historyEmpty = CollectionUtils.isEmpty((Collection)histories)) || !fieldSet.isEmpty()) {
                history = (History)historyDao.create("type", (Object)(historyEmpty ? HistoryType.CREATION : HistoryType.MODIFICATION), new Object[]{"faxToMailUser", user, "modificationDate", now, "email", email, "fieldsJson", AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson((Object)fieldSet)});
            }
        }
        if (history != null) {
            email.addHistory(history);
        }
        Email result = (Email)dao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return result;
    }

    protected void updateReplies(Email email) {
        ReplyTopiaDao replyTopiaDao = this.getPersistenceContext().getReplyDao();
        ArrayList currentReplies = new ArrayList(email.getReplies());
        email.clearReplies();
        for (Reply reply : currentReplies) {
            Reply newReply = (Reply)replyTopiaDao.forTopiaIdEquals(reply.getTopiaId()).findUnique();
            email.addReplies(newReply);
        }
    }

    protected void updateAttachments(Email email, Collection<Attachment> attachments, FaxToMailUser user) {
        AttachmentTopiaDao attachmentTopiaDao = this.getPersistenceContext().getAttachmentDao();
        HistoryTopiaDao historyTopiaDao = this.getPersistenceContext().getHistoryDao();
        ArrayList<AttachmentImpl> currentAttachments = attachmentTopiaDao.forTopiaIdIn(email.getAttachmentTopiaIds()).findAll();
        if (currentAttachments == null) {
            currentAttachments = new ArrayList<AttachmentImpl>();
        }
        HashMap currentAttachmentIndex = new HashMap(Maps.uniqueIndex(currentAttachments, (Function)TopiaEntities.getTopiaIdFunction()));
        HashSet<String> newFiles = new HashSet<String>();
        AttachmentFileTopiaDao attachementFileTopiaDao = this.getPersistenceContext().getAttachmentFileDao();
        for (Attachment attachment : attachments) {
            Object currentAttachment = StringUtils.isNotBlank((CharSequence)attachment.getTopiaId()) ? (Attachment)currentAttachmentIndex.remove(attachment.getTopiaId()) : new AttachmentImpl();
            AttachmentFile originalFile = null;
            AttachmentFile editedFile = null;
            originalFile = attachment.getOriginalFile() != null ? attachment.getOriginalFile() : currentAttachment.getOriginalFile();
            editedFile = attachment.getEditedFile() != null ? attachment.getEditedFile() : currentAttachment.getEditedFile();
            this.attachmentBinder.copyExcluding((Object)attachment, currentAttachment, new String[]{"email", "editedFile", "editedFileName", "originalFile", "originalFileName", "topiaCreateDate", "topiaId", "topiaVersion"});
            currentAttachment.setEmail(email);
            currentAttachment.setEditedFile(editedFile);
            currentAttachment.setOriginalFile(originalFile);
            if (!originalFile.isPersisted()) {
                attachementFileTopiaDao.create((TopiaEntity)originalFile);
                newFiles.add(originalFile.getFilename());
            } else {
                attachementFileTopiaDao.update((TopiaEntity)originalFile);
            }
            if (editedFile != null) {
                if (!editedFile.isPersisted()) {
                    attachementFileTopiaDao.create((TopiaEntity)editedFile);
                } else {
                    attachementFileTopiaDao.update((TopiaEntity)editedFile);
                }
            }
            if (!currentAttachment.isPersisted()) {
                currentAttachment = (Attachment)attachmentTopiaDao.create((TopiaEntity)currentAttachment);
                currentAttachments.add((AttachmentImpl)currentAttachment);
                continue;
            }
            attachmentTopiaDao.update((TopiaEntity)currentAttachment);
        }
        if (!newFiles.isEmpty()) {
            History history = (History)historyTopiaDao.create("type", (Object)HistoryType.ATTACHMENT_ADDITION, new Object[]{"faxToMailUser", user, "modificationDate", new Date(), "email", email, "fieldsJson", AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson(newFiles)});
            email.addHistory(history);
        }
        for (Attachment attachment : currentAttachmentIndex.values()) {
            currentAttachments.remove(attachment);
        }
        email.setAttachment(currentAttachments);
    }

    protected void handleEdiTransmission(Email email, HistoryTopiaDao historyDao, Set<String> fieldSet) {
        if (FaxToMailServiceUtils.contains(email.getDemandType().getRequiredFields(), MailField.RANGE_ROW) && email.getDemandType().isEdiTransfer()) {
            if (email.isRangeRowNotEmpty()) {
                Boolean ediTranfer = null;
                MailFolder loopFolder = email.getMailFolder();
                do {
                    ediTranfer = loopFolder.getEdiTransfer();
                    loopFolder = loopFolder.getParent();
                } while (ediTranfer == null && loopFolder != null);
                if (BooleanUtils.isTrue((Boolean)ediTranfer)) {
                    History transmissionToEdi = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION_TO_EDI, new Object[]{"modificationDate", new Date(), "email", email});
                    email.addHistory(transmissionToEdi);
                    email.setDemandStatus(DemandStatus.TRANSMISSION_TO_EDI);
                    fieldSet.add("demandStatus");
                } else {
                    if (email.getDemandStatus() == DemandStatus.UNTREATED) {
                        email.setDemandStatus(DemandStatus.IN_PROGRESS);
                    }
                    fieldSet.add("demandStatus");
                }
            }
        } else {
            if (email.getDemandStatus() == DemandStatus.UNTREATED) {
                email.setDemandStatus(DemandStatus.IN_PROGRESS);
            }
            fieldSet.add("demandStatus");
        }
    }

    @Override
    public void transmitPendingDemandsToEdi() {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        List toTransmitToEdi = dao.forDemandStatusEquals(DemandStatus.TRANSMISSION_TO_EDI).findAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)(toTransmitToEdi.size() + " demands to transmit to edi"));
        }
        for (Email email : toTransmitToEdi) {
            this.transmitDemandToEdi(email);
        }
    }

    protected void transmitDemandToEdi(Email email) {
        Preconditions.checkArgument((email.getDemandStatus() == DemandStatus.TRANSMISSION_TO_EDI ? 1 : 0) != 0);
        Preconditions.checkArgument((!email.getRangeRow().isEmpty() ? 1 : 0) != 0);
        MailFolder folder = email.getMailFolder();
        while (!folder.isUseCurrentLevelEdiFolder() && folder.getParent() != null) {
            folder = folder.getParent();
        }
        String ediFolder = folder.getEdiFolder();
        if (StringUtils.isBlank((CharSequence)ediFolder)) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)("Aucun dossier de depot des demandes EDI d\u00e9fini pour le dossier " + folder.getName()));
            }
            return;
        }
        File ediFolderDirectory = new File(ediFolder);
        if (!ediFolderDirectory.canWrite()) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)("Le dossier " + ediFolderDirectory.getAbsolutePath() + " ne dispose pas des droits d'\u00e9criture !"));
            }
            return;
        }
        Date now = this.serviceContext.getNow();
        String fileDate = DateFormatUtils.format((Date)now, (String)"yyMMddHHmmss");
        for (RangeRow rangeRow : email.getRangeRow()) {
            String fileName = "ORD_FAX_" + fileDate + "_" + rangeRow.getTopiaId() + ".txt";
            File ediFile = new File(ediFolderDirectory, fileName);
            String separator = ";";
            try {
                BufferedWriter ediWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ediFile), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    ediWriter.write("%BEGIN_ENTETE_QUOTE\n");
                    ediWriter.write("E" + separator);
                    ediWriter.write("OARFAX" + separator);
                    ediWriter.write(DateFormatUtils.format((Date)now, (String)"ddMMyy") + separator);
                    ediWriter.write(DateFormatUtils.format((Date)email.getReceptionDate(), (String)"ddMMyy") + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(Strings.nullToEmpty((String)email.getProjectReference()) + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write("EUR" + separator);
                    ediWriter.write(separator);
                    ediWriter.write(email.getDemandType().getLabel() + separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(separator);
                    ediWriter.write(email.getClient().getCode() + separator);
                    ediWriter.write(email.getClient().getCode() + separator);
                    ediWriter.write(rangeRow.getRange().getLabel() + separator);
                    ediWriter.write(rangeRow.getTopiaId() + "\n");
                    ediWriter.write("%END_ENTETE_QUOTE\n");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ediWriter == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)ediWriter).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((Writer)ediWriter).close();
                }
            }
            catch (IOException ex) {
                FileUtils.deleteQuietly((File)ediFile);
                throw new RuntimeException("Can't generate EDI file");
            }
        }
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        email.setDemandStatus(DemandStatus.TRANSMITTED_TO_EDI);
        History history = (History)historyDao.create("type", (Object)HistoryType.TRANSMITTED_TO_EDI, new Object[]{"modificationDate", new Date(), "email", email});
        email.addHistory(history);
        dao.update((TopiaEntity)email);
    }

    @Override
    public Set<Object> getDistinctValues(MailFolder folder, String[] properties, boolean sum) {
        Set result = null;
        if (folder.isFolderReadable()) {
            EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
            result = dao.getDistinctValues(folder, properties, sum);
        }
        return result;
    }

    @Override
    public PaginationResult<Email> getEmailForFolder(MailFolder folder, FaxToMailUser currentUser, EmailFilter filter, PaginationParameter page) {
        PaginationResult result;
        if (folder.isFolderReadable()) {
            EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
            result = dao.getEmailForFolder(filter, folder, page);
        } else {
            List elements = Collections.emptyList();
            result = PaginationResult.of(elements, (long)0L, (PaginationParameter)page);
        }
        return result;
    }

    @Override
    public List<MailFolder> getChildrenRecursively(MailFolder folder) {
        ArrayList<MailFolder> folders = new ArrayList<MailFolder>();
        folders.add(folder);
        Collection children = folder.getChildren();
        if (children != null) {
            for (MailFolder child : children) {
                folders.addAll(this.getChildrenRecursively(child));
            }
        }
        return folders;
    }

    @Override
    public Map<Range, Long[]> computeQuantitiesByRange(MailFolder rootFolder) {
        List<MailFolder> folders = this.getChildrenRecursively(rootFolder);
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Map daoResult = emailDao.computeQuantitiesByRange(folders);
        RangeTopiaDao rangeDao = this.getPersistenceContext().getRangeDao();
        TreeMap<Range, Long[]> result = new TreeMap<Range, Long[]>(new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        for (Map.Entry entry : daoResult.entrySet()) {
            Range range = (Range)rangeDao.forTopiaIdEquals((String)entry.getKey()).findUnique();
            result.put(range, (Long[])entry.getValue());
        }
        return result;
    }

    @Override
    public Email addToHistory(String emailId, HistoryType type, FaxToMailUser user, Date date, String ... fields) {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Email email = this.getEmailById(emailId, "history.faxToMailUser", new String[0]);
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)type, new Object[]{"faxToMailUser", user, "modificationDate", date, "email", email, "fieldsJson", AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson((Object)fields)});
        email.addHistory(history);
        if (type == HistoryType.ATTACHMENT_OPENING) {
            email.setLastAttachmentOpener(user);
        }
        email = (Email)emailDao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return email;
    }

    @Override
    public Email openEmail(String emailId, FaxToMailUser user, boolean takeEmail) throws FolderNotReadableException {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Email email = this.getFullEmailById(emailId, user);
        MailFolder mailFolder = email.getMailFolder();
        if (!mailFolder.isFolderReadable()) {
            throw new FolderNotReadableException(String.format("Mail folder %s not readable by %s", mailFolder.getName(), user.getLogin()), mailFolder);
        }
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)HistoryType.OPENING, new Object[]{"faxToMailUser", user, "modificationDate", new Date(), "email", email});
        email.addHistory(history);
        if (takeEmail) {
            String jsonFields = AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson((Object)Sets.newHashSet((Object[])new String[]{"takenBy"}));
            history = (History)historyDao.create("type", (Object)HistoryType.MODIFICATION, new Object[]{"faxToMailUser", user, "modificationDate", new Date(), "email", email, "fieldsJson", jsonFields});
            email.addHistory(history);
            email.setTakenBy(user);
        }
        email = (Email)emailDao.update((TopiaEntity)email);
        this.getPersistenceContext().commit();
        return email;
    }

    @Override
    public Email lockEmail(String emailId, FaxToMailUser currentUser) throws AlreadyLockedMailException, FolderNotReadableException {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        Email email = (Email)emailDao.forTopiaIdEquals(emailId).findUnique();
        MailFolderService mailFolderService = this.serviceContext.getMailFolderService();
        MailFolder folder = email.getMailFolder();
        this.browseFolderParent(folder, currentUser, mailFolderService);
        if (!folder.isFolderReadable()) {
            throw new FolderNotReadableException(String.format("Mail folder %s not readable by %s", folder.getName(), currentUser.getLogin()), folder);
        }
        Hibernate.initialize((Object)email.getTakenBy());
        MailLock mailLock = (MailLock)mailLockDao.forLockOnEquals(email).findUniqueOrNull();
        if (mailLock == null) {
            List mailLocksToRemove = email.getEmailGroup() != null ? mailLockDao.forLockByEquals(currentUser).addNotEquals("lockOn.emailGroup", (Object)email.getEmailGroup()).findAll() : mailLockDao.forLockByEquals(currentUser).findAll();
            if (log.isDebugEnabled()) {
                for (MailLock mailLockToRemove : mailLocksToRemove) {
                    log.debug((Object)("[UNLOCK] " + mailLockToRemove.getLockOn().getTopiaId() + " unlocked (automatic)"));
                }
            }
            mailLockDao.deleteAll((Iterable)mailLocksToRemove);
            mailLock = new MailLockImpl();
            mailLock.setLockBy(currentUser);
            mailLock.setLockOn(email);
            mailLock = (MailLock)mailLockDao.create((TopiaEntity)mailLock);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[LOCK] " + emailId + " locked by " + currentUser.getLogin()));
            }
            this.getPersistenceContext().commit();
        } else if (!mailLock.getLockBy().equals(currentUser)) {
            throw new AlreadyLockedMailException(String.format("Mail %s already locked by %s", emailId, mailLock.getLockBy().getTopiaId()), mailLock.getLockBy());
        }
        return email;
    }

    @Override
    public void unlockEmail(String emailId) {
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        MailLock mailLock = (MailLock)mailLockDao.forAll().addEquals("lockOn.topiaId", (Object)emailId).findUniqueOrNull();
        if (mailLock != null) {
            mailLockDao.delete(mailLock);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[UNLOCK] " + emailId + " unlocked"));
            }
            this.getPersistenceContext().commit();
        }
    }

    protected void computeUserReadableFolder(Set<MailFolder> readMailFolders, Iterable<MailFolder> mailFolders) {
        if (mailFolders != null) {
            for (MailFolder mailFolder : mailFolders) {
                readMailFolders.add(mailFolder);
                this.computeUserReadableFolder(readMailFolders, mailFolder.getChildren());
            }
        }
    }

    @Override
    public PaginationResult<Email> search(SearchFilter emailFilter, FaxToMailUser user, PaginationParameter pagination) {
        MailFolderTopiaDao mailFolderDao = this.getPersistenceContext().getMailFolderDao();
        HashSet<MailFolder> readMailFolders = new HashSet<MailFolder>();
        List mailFolders = mailFolderDao.forReadRightUsersContains(user).findAll();
        this.computeUserReadableFolder(readMailFolders, mailFolders);
        if (user.getUserGroups() != null) {
            for (FaxToMailUserGroup group : user.getUserGroups()) {
                mailFolders = mailFolderDao.forReadRightGroupsContains(group).findAll();
                this.computeUserReadableFolder(readMailFolders, mailFolders);
            }
        }
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        PaginationResult result = emailDao.search(emailFilter, readMailFolders, pagination);
        return result;
    }

    @Override
    public Collection<Email> searchArchives(String commandQuotationNumber, String company) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)commandQuotationNumber));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)company));
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        return emailDao.findArchivedEmails(commandQuotationNumber, company);
    }

    @Override
    public Email groupEmails(String email1Id, String email2Id, FaxToMailUser user) {
        EmailGroupTopiaDao groupDao = this.getPersistenceContext().getEmailGroupDao();
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        Email email1 = this.getFullEmailById(email1Id, user);
        Email email2 = this.getFullEmailById(email2Id, user);
        EmailGroup group1 = email1.getEmailGroup();
        EmailGroup group2 = email2.getEmailGroup();
        if (group1 == null && group2 == null) {
            EmailGroup group = (EmailGroup)groupDao.create("email", (Object)Sets.newHashSet((Object[])new Email[]{email1, email2}), new Object[0]);
            email1.setEmailGroup(group);
            email2.setEmailGroup(group);
        } else if (group1 == null) {
            email1.setEmailGroup(group2);
            group2.addEmail(email1);
            groupDao.update((TopiaEntity)group2);
        } else if (group2 == null) {
            email2.setEmailGroup(group1);
            group1.addEmail(email2);
            groupDao.update((TopiaEntity)group1);
        } else {
            if (group1.equals(group2)) {
                return email1;
            }
            HashSet group2Emails = new HashSet(group2.getEmail());
            group2.clearEmail();
            group1.addAllEmail(group2Emails);
            groupDao.delete(group2);
            groupDao.update((TopiaEntity)group1);
        }
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        Date now = new Date();
        String jsonFields = AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson((Object)Sets.newHashSet((Object[])new String[]{email2.getObject()}));
        History history = (History)historyDao.create("type", (Object)HistoryType.GROUP, new Object[]{"faxToMailUser", user, "modificationDate", now, "email", email1, "fieldsJson", jsonFields});
        email1.addHistory(history);
        Email result = (Email)emailDao.update((TopiaEntity)email1);
        jsonFields = AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson((Object)Sets.newHashSet((Object[])new String[]{email1.getObject()}));
        History history2 = (History)historyDao.create("type", (Object)HistoryType.GROUP, new Object[]{"faxToMailUser", user, "modificationDate", now, "email", email2, "fieldsJson", jsonFields});
        email2.addHistory(history2);
        emailDao.update((TopiaEntity)email2);
        this.getPersistenceContext().commit();
        return result;
    }

    @Override
    public Email reply(String from, String to, String cc, String bcc, String subject, String content, Collection<AttachmentFile> attachments, String originalEmailId, FaxToMailUser user) throws EmailException, MessagingException, IOException {
        Email email = this.getEmailById(originalEmailId, "history.faxToMailUser", "replies");
        String smtpUser = this.getApplicationConfig().getSmtpUser();
        String password = this.getApplicationConfig().getSmtpPassword();
        boolean useSsl = this.getApplicationConfig().isSmtpUseSsl();
        MultiPartEmail message = new MultiPartEmail();
        message.setHostName(this.getApplicationConfig().getSmtpHost());
        message.setSmtpPort(this.getApplicationConfig().getSmtpPort());
        if (StringUtils.isNotBlank((CharSequence)smtpUser) && password != null) {
            message.setAuthenticator((Authenticator)new DefaultAuthenticator(smtpUser, password));
        }
        message.setSSLOnConnect(useSsl);
        message.setCharset("utf-8");
        message.setFrom(from);
        String[] tos = to.split("\\s*;\\s*");
        message.addTo(tos);
        if (StringUtils.isNotBlank((CharSequence)cc)) {
            String[] ccs = cc.split("\\s*;\\s*");
            message.addCc(ccs);
        }
        if (StringUtils.isNotBlank((CharSequence)bcc)) {
            String[] bccs = bcc.split("\\s*;\\s*");
            message.addBcc(bccs);
        }
        message.setSubject(subject);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            message.setMsg(content);
        }
        for (AttachmentFile attachmentFile : attachments) {
            File file = attachmentFile.getFile();
            FileDataSource source = new FileDataSource(file);
            message.attach((DataSource)source, attachmentFile.getFilename(), null);
        }
        message.send();
        ReplyTopiaDao replyTopiaDao = this.getPersistenceContext().getReplyDao();
        ReplyContentTopiaDao replyContentTopiaDao = this.getPersistenceContext().getReplyContentDao();
        Date now = new Date();
        StringBuilder emailHeaders = new StringBuilder();
        Enumeration headerLines = message.getMimeMessage().getAllHeaderLines();
        while (headerLines.hasMoreElements()) {
            String headerLine = (String)headerLines.nextElement();
            emailHeaders.append(headerLine).append("\n");
        }
        emailHeaders.append("\n");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        IOUtils.write((CharSequence)emailHeaders, (OutputStream)byteOut);
        IOUtils.copy((InputStream)message.getMimeMessage().getInputStream(), (OutputStream)byteOut);
        ReplyContent replyContent = replyContentTopiaDao.createByNotNull(byteOut.toByteArray());
        Reply reply = (Reply)replyTopiaDao.create("replyContent", (Object)replyContent, new Object[]{"sentDate", now, "subject", subject, "sender", from, "recipient", to, "sentBy", user});
        email.addReplies(reply);
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        History history = (History)historyDao.create("type", (Object)HistoryType.REPLY, new Object[]{"faxToMailUser", user, "modificationDate", now, "email", email});
        email.addHistory(history);
        Client client = email.getClient();
        email = this.saveEmail(email, null, null, client != null ? client.getCode() : null, user, new String[0]);
        return email;
    }

    @Override
    public void transmit(Collection<String> emailIds, MailFolder newFolder, FaxToMailUser currentUser) {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        List emails = dao.forTopiaIdIn(emailIds).findAll();
        for (Email email : emails) {
            if (email.getDemandStatus() != DemandStatus.TRANSMISSION_TO_EDI && email.getDemandStatus() != DemandStatus.TRANSMITTED_TO_EDI) {
                email.setDemandStatus(DemandStatus.QUALIFIED);
            }
            email.setMailFolder(newFolder);
            email.setTakenBy(null);
            email.setLastAttachmentOpener(null);
            History history = (History)historyDao.create("type", (Object)HistoryType.TRANSMISSION, new Object[]{"faxToMailUser", currentUser, "modificationDate", new Date(), "email", email});
            email.addHistory(history);
        }
        dao.updateAll((Iterable)emails);
        this.getPersistenceContext().commit();
    }

    @Override
    public AttachmentFile getAttachmentFileFromStream(InputStream contentStream) {
        AttachmentFileImpl attachmentFile = new AttachmentFileImpl();
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)contentStream, (OutputStream)output);
            attachmentFile.setContent(output.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't save content", ex);
        }
        return attachmentFile;
    }

    @Override
    public AttachmentFile getAttachmentFile(String attachmentId, boolean original) {
        AttachmentFile result;
        AttachmentTopiaDao dao = this.getPersistenceContext().getAttachmentDao();
        Attachment attachment = (Attachment)dao.forTopiaIdEquals(attachmentId).findUnique();
        AttachmentFile attachmentFile = result = original ? attachment.getOriginalFile() : attachment.getEditedFile();
        if (result != null) {
            Hibernate.initialize((Object)result);
        }
        return result;
    }

    @Override
    public ReplyContent getReplyContent(String replyId) {
        ReplyTopiaDao dao = this.getPersistenceContext().getReplyDao();
        Reply reply = (Reply)dao.forTopiaIdEquals(replyId).findUnique();
        ReplyContent result = reply.getReplyContent();
        Hibernate.initialize((Object)result);
        return result;
    }

    @Override
    public List<MailLock> getAllMailLocks() {
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        List result = mailLockDao.findAll();
        return result;
    }

    @Override
    public void unlockMails(List<String> mailLockIds) {
        MailLockTopiaDao mailLockDao = this.getPersistenceContext().getMailLockDao();
        List mailLocks = mailLockDao.forTopiaIdIn(mailLockIds).findAll();
        mailLockDao.deleteAll((Iterable)mailLocks);
        this.getPersistenceContext().commit();
    }

    @Override
    public void rejectEmail(String from, String to, String subject, String content) throws EmailException, MessagingException, IOException {
        String smtpUser = this.getApplicationConfig().getSmtpUser();
        String password = this.getApplicationConfig().getSmtpPassword();
        boolean useSsl = this.getApplicationConfig().isSmtpUseSsl();
        MultiPartEmail message = new MultiPartEmail();
        message.setHostName(this.getApplicationConfig().getSmtpHost());
        message.setSmtpPort(this.getApplicationConfig().getSmtpPort());
        if (StringUtils.isNotBlank((CharSequence)smtpUser) && password != null) {
            message.setAuthenticator((Authenticator)new DefaultAuthenticator(smtpUser, password));
        }
        message.setSSLOnConnect(useSsl);
        message.setCharset("utf-8");
        message.setFrom(from);
        message.addTo(to);
        message.setSubject(subject);
        message.setMsg(content);
        message.send();
    }

    @Override
    public void updateRangeRowsWithEdiReturns() {
        final RangeRowTopiaDao rangeRowTopiaDao = this.getPersistenceContext().getRangeRowDao();
        final EmailTopiaDao emailTopiaDao = this.getPersistenceContext().getEmailDao();
        final HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
        final HashSet emailsToUpdate = new HashSet();
        TopiaSqlSupport sqlSupport = this.getPersistenceContext().getSqlSupport();
        sqlSupport.doSqlWork(new TopiaSqlWork(){

            public void execute(Connection connection) throws SQLException {
                int importedCount = 0;
                ArrayList<String> rangeRowTopiaIdsInEdiReturnToDelete = new ArrayList<String>();
                String query = String.format("SELECT %s, %s, %s FROM %s", "rangeRowTopiaId", "commandNumber", "error", EdiReturn.class.getSimpleName());
                Statement stat = connection.createStatement();
                ResultSet resultSet = stat.executeQuery(query);
                while (resultSet.next()) {
                    String rangeRowTopiaId = resultSet.getString("rangeRowTopiaId");
                    String commandNumber = resultSet.getString("commandNumber");
                    String error = resultSet.getString("error");
                    RangeRow rangeRow = (RangeRow)rangeRowTopiaDao.forTopiaIdEquals(rangeRowTopiaId).findUniqueOrNull();
                    if (rangeRow == null) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Can't find rangeRow " + rangeRowTopiaId + " to update"));
                        continue;
                    }
                    Email email = (Email)emailTopiaDao.forRangeRowContains(rangeRow).findUniqueOrNull();
                    if (email == null) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Can't find email for " + rangeRowTopiaId + " to update"));
                        continue;
                    }
                    rangeRowTopiaIdsInEdiReturnToDelete.add(rangeRowTopiaId);
                    HashSet<String> modifiedFields = new HashSet<String>();
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        String oldError = email.getEdiError();
                        if (StringUtils.isNotBlank((CharSequence)oldError)) {
                            error = oldError + ", " + error;
                        }
                        email.setEdiError(error);
                        modifiedFields.add("ediError");
                    } else {
                        rangeRow.setCommandNumber(commandNumber);
                        rangeRowTopiaDao.update((TopiaEntity)rangeRow);
                        modifiedFields.add("rangeRow");
                    }
                    History transmission = (History)CollectionUtils.find((Iterable)email.getHistory(), (org.apache.commons.collections4.Predicate)new org.apache.commons.collections4.Predicate<History>(){

                        public boolean evaluate(History object) {
                            return object.getType() == HistoryType.TRANSMISSION;
                        }
                    });
                    if (transmission != null) {
                        email.setDemandStatus(DemandStatus.QUALIFIED);
                    } else {
                        email.setDemandStatus(DemandStatus.IN_PROGRESS);
                    }
                    modifiedFields.add("demandStatus");
                    History history = (History)historyDao.create("type", (Object)HistoryType.MODIFICATION, new Object[]{"modificationDate", new Date(), "email", email, "fieldsJson", AbstractFaxToMailTopiaDao.GSON_INSTANCE.toJson(modifiedFields)});
                    email.addHistory(history);
                    history = (History)historyDao.create("type", (Object)HistoryType.EDI_RETURN, new Object[]{"modificationDate", new Date(), "email", email});
                    email.addHistory(history);
                    emailsToUpdate.add(email);
                    ++importedCount;
                }
                stat = connection.createStatement();
                stat.execute("DELETE FROM " + EdiReturn.class.getSimpleName() + " WHERE " + "rangeRowTopiaId" + " IN ('" + StringUtils.join(rangeRowTopiaIdsInEdiReturnToDelete, (String)"','") + "')");
                if (importedCount > 0 && log.isInfoEnabled()) {
                    log.info((Object)String.format("Imported %d ediReturn rows", importedCount));
                }
            }
        });
        emailTopiaDao.updateAll(emailsToUpdate);
        this.getPersistenceContext().commit();
    }

    @Override
    public OriginalEmail originalEmailFromMessage(MimeMessage message, Charset charset) throws MessagingException, IOException {
        InputStream inputStream;
        StringBuilder emailSource = new StringBuilder();
        Enumeration headerLines = message.getAllHeaderLines();
        while (headerLines.hasMoreElements()) {
            String headerLine = (String)headerLines.nextElement();
            emailSource.append(headerLine).append("\n");
        }
        try {
            inputStream = message.getRawInputStream();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"error while getting the raw input stream");
            }
            inputStream = message.getInputStream();
        }
        String originalContent = IOUtils.toString((InputStream)inputStream, (Charset)charset);
        emailSource.append("\n").append(originalContent);
        OriginalEmail originalEmail = (OriginalEmail)this.getPersistenceContext().getOriginalEmailDao().newInstance();
        originalEmail.setContent(emailSource.toString());
        return originalEmail;
    }

    @Override
    public AttachmentFile getEmailDetailAsAttachment(Email email) {
        AttachmentFileImpl result;
        block2: {
            result = null;
            try {
                String content = this.getEmailDetailAsHtml(email);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocumentFromString(content);
                renderer.layout();
                renderer.createPDF((OutputStream)out);
                result = new AttachmentFileImpl();
                result.setContent(out.toByteArray());
                result.setFilename(I18n.t((String)"faxtomail.attachment.demand.filename", (Object[])new Object[0]) + ".pdf");
                result.getFile();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    protected String getEmailDetailAsHtml(Email email) {
        Decorator<FaxToMailUser> userDecorator = this.getDecoratorService().getDecoratorByType(FaxToMailUser.class);
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        scopes.put("title", email.getTitle());
        scopes.put("receivedDate", DateFormatUtils.format((Date)email.getReceptionDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("sender", email.getSender());
        scopes.put("object", email.getObject());
        scopes.put("client", email.getClient());
        scopes.put("demandType", email.getDemandType());
        scopes.put("priority", email.getPriority());
        scopes.put("projectReference", email.getProjectReference());
        scopes.put("companyReference", email.getCompanyReference());
        scopes.put("waitingState", email.getWaitingState());
        scopes.put("status", email.getDemandStatus());
        scopes.put("takenBy", email.getTakenBy() == null ? "" : userDecorator.toString((Object)email.getTakenBy()));
        scopes.put("message", email.getComment());
        scopes.put("date", DateFormatUtils.format((Date)this.serviceContext.getNow(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("firstOpeningUser", email.getFirstOpeningUser() == null ? "" : userDecorator.toString((Object)email.getFirstOpeningUser()));
        scopes.put("firstOpeningDate", email.getFirstOpeningDate() == null ? "" : DateFormatUtils.format((Date)email.getFirstOpeningDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("lastModificationUser", email.getLastModificationUser() == null ? "" : userDecorator.toString((Object)email.getLastModificationUser()));
        scopes.put("lastModificationDate", email.getLastModificationDate() == null ? "" : DateFormatUtils.format((Date)email.getLastModificationDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("lastAttachmentOpeningInFolderUser", email.getLastAttachmentOpeningInFolderUser() == null ? "" : userDecorator.toString((Object)email.getLastAttachmentOpeningInFolderUser()));
        scopes.put("lastAttachmentOpeningInFolderDate", email.getLastAttachmentOpeningInFolderDate() == null ? "" : DateFormatUtils.format((Date)email.getLastAttachmentOpeningInFolderDate(), (String)"dd/MM/yyyy HH:mm"));
        scopes.put("hasRangeRows", email.sizeRangeRow() > 0);
        scopes.put("rangeRows", email.getRangeRow());
        InputStream is = EmailServiceImpl.class.getResourceAsStream("/pdf/demande.mustache");
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), "demande");
        StringWriter writer = new StringWriter();
        mustache.execute((Writer)writer, scopes);
        writer.flush();
        return writer.toString();
    }

    @Override
    public ArchiveImportResult importArchive(InputStream inputStream, File attachmentBase) {
        FaxToMailTopiaPersistenceContext persistenceContext = this.getPersistenceContext();
        TopiaHibernateSupport hibernateSupport = persistenceContext.getHibernateSupport();
        StatelessSession statelessSession = hibernateSupport.getHibernateFactory().openStatelessSession();
        Transaction transaction = statelessSession.beginTransaction();
        EmailTopiaDao emailDao = persistenceContext.getEmailDao();
        DemandTypeTopiaDao demandTypedao = persistenceContext.getDemandTypeDao();
        PriorityTopiaDao priorityDao = persistenceContext.getPriorityDao();
        WaitingStateTopiaDao waitingStateDao = persistenceContext.getWaitingStateDao();
        MailFolderTopiaDao mailFolderDao = persistenceContext.getMailFolderDao();
        AttachmentTopiaDao attachmentDao = persistenceContext.getAttachmentDao();
        AttachmentFileTopiaDao attachmentFileDao = persistenceContext.getAttachmentFileDao();
        HistoryTopiaDao historyDao = persistenceContext.getHistoryDao();
        OriginalEmailTopiaDao originalEmailTopiaDao = this.getPersistenceContext().getOriginalEmailDao();
        int commitThreshold = this.getApplicationConfig().getArchiveImportCommitTreshold();
        if (log.isInfoEnabled()) {
            log.info((Object)("commit every " + commitThreshold + " archives imported"));
        }
        ImmutableMap allDemandTypes = Maps.uniqueIndex((Iterable)demandTypedao, (Function)new Function<DemandType, String>(){

            public String apply(DemandType input) {
                return input.getLabel();
            }
        });
        ImmutableMap allPriority = Maps.uniqueIndex((Iterable)priorityDao, (Function)new Function<Priority, String>(){

            public String apply(Priority input) {
                return input.getLabel();
            }
        });
        ImmutableMap allWaitingStates = Maps.uniqueIndex((Iterable)waitingStateDao, (Function)new Function<WaitingState, String>(){

            public String apply(WaitingState input) {
                return input.getLabel();
            }
        });
        ImmutableMap mailFolderMap = Maps.uniqueIndex((Iterable)mailFolderDao, (Function)new Function<MailFolder, String>(){

            public String apply(MailFolder input) {
                return FaxToMailServiceUtils.getFullMailFolderPath(input);
            }
        });
        ArchiveImportExportModel archiveImportExportModel = new ArchiveImportExportModel(';', (Map<String, WaitingState>)allWaitingStates, (Map<String, DemandType>)allDemandTypes, (Map<String, Priority>)allPriority);
        Binder emailBinder = BinderFactory.newBinder(ArchiveImportExportBean.class, Email.class);
        Import importer = null;
        HashMap<MailFolder, MailFolder> archiveFoldersByFolder = new HashMap<MailFolder, MailFolder>();
        HashMap<MailFolder, String> companyByFolder = new HashMap<MailFolder, String>();
        ArchiveImportResult result = new ArchiveImportResult();
        HashSet<ArchiveImportExportBean> notImportedBeans = new HashSet<ArchiveImportExportBean>();
        HashSet<ArchiveImportExportBean> toCommitBeans = new HashSet<ArchiveImportExportBean>();
        try {
            importer = Import.newImport((ImportModel)archiveImportExportModel, (Reader)new InputStreamReader(inputStream, this.getApplicationConfig().getImportFileEncoding()));
            Iterator iterator = importer.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                try {
                    Email email;
                    ArchiveImportExportBean archiveBean;
                    block33: {
                        archiveBean = (ArchiveImportExportBean)((Object)iterator.next());
                        toCommitBeans.add(archiveBean);
                        ++index;
                        if (archiveBean.getProjectReference() == null) {
                            log.error((Object)("null project ref for " + archiveBean.getReceptionDate()));
                        }
                        String mailFolderPath = archiveBean.getMailFolderPath();
                        MailFolder folder = (MailFolder)mailFolderMap.get(mailFolderPath);
                        archiveBean.setMailFolder(folder);
                        if (archiveBean.getMailFolder() == null) {
                            log.error((Object)("null mail folder for " + archiveBean.getReceptionDate()));
                            String errorMessage = I18n.t((String)"faxtomail.archives.import.error.invalidFolder", (Object[])new Object[]{mailFolderPath});
                            throw new InvalidArchiveImportBeanException(errorMessage, archiveBean);
                        }
                        email = (Email)emailDao.newInstance();
                        emailBinder.copy((Object)archiveBean, (Object)email, new String[0]);
                        email.setDemandStatus(DemandStatus.ARCHIVED);
                        MailFolder archiveChild = null;
                        String company = null;
                        boolean companyFound = false;
                        if (!archiveFoldersByFolder.containsKey(folder)) {
                            do {
                                Optional optArchiveChild;
                                if (archiveChild == null && folder.getChildren() != null && (optArchiveChild = Iterables.tryFind((Iterable)folder.getChildren(), (Predicate)new Predicate<MailFolder>(){

                                    public boolean apply(MailFolder mailFolder) {
                                        return mailFolder.isArchiveFolder();
                                    }
                                })).isPresent()) {
                                    archiveChild = (MailFolder)optArchiveChild.get();
                                }
                                if (!companyFound && folder.isUseCurrentLevelCompany()) {
                                    companyFound = true;
                                    company = folder.getCompany();
                                }
                                folder = folder.getParent();
                            } while ((archiveChild == null || !companyFound) && folder != null);
                            archiveFoldersByFolder.put(folder, archiveChild);
                            companyByFolder.put(folder, company);
                        } else {
                            archiveChild = (MailFolder)archiveFoldersByFolder.get(folder);
                            company = (String)companyByFolder.get(folder);
                        }
                        if (archiveChild != null) {
                            email.setMailFolder(archiveChild);
                        }
                        Client client = this.getClientService().getClientForCode(archiveBean.getClientCode(), company);
                        email.setClient(client);
                        OriginalEmail originalEmail = (OriginalEmail)originalEmailTopiaDao.newInstance();
                        String originalEmailContent = archiveBean.getOriginalEmailContent();
                        originalEmail.setContent(originalEmailContent != null ? originalEmailContent : "");
                        originalEmail.setTopiaId(this.getTopiaId(OriginalEmail.class, (TopiaEntity)originalEmail));
                        statelessSession.insert((Object)originalEmail);
                        email.setOriginalEmail(originalEmail);
                        email.setTopiaId(this.getTopiaId(Email.class, (TopiaEntity)email));
                        statelessSession.insert((Object)email);
                        History history = (History)historyDao.newInstance();
                        history.setType(HistoryType.ARCHIVED);
                        history.setModificationDate(new Date());
                        history.setEmail(email);
                        history.setTopiaId(this.getTopiaId(History.class, (TopiaEntity)history));
                        statelessSession.insert((Object)history);
                        if (StringUtils.isNotBlank((CharSequence)originalEmailContent)) {
                            try {
                                Attachment contentAttachment = this.convertTextToPdf(originalEmailContent, I18n.t((String)"faxtomail.email.content.attachment.plainFileName", (Object[])new Object[0]));
                                AttachmentFile contentAttachmentFile = contentAttachment.getOriginalFile();
                                contentAttachmentFile.setTopiaId(this.getTopiaId(AttachmentFile.class, (TopiaEntity)contentAttachmentFile));
                                statelessSession.insert((Object)contentAttachmentFile);
                                contentAttachment.setEmail(email);
                                contentAttachment.setTopiaId(this.getTopiaId(Attachment.class, (TopiaEntity)contentAttachment));
                                statelessSession.insert((Object)contentAttachment);
                            }
                            catch (DocumentException | IOException e) {
                                if (!log.isErrorEnabled()) break block33;
                                log.error((Object)"error while creating email content attachment", e);
                            }
                        }
                    }
                    if (archiveBean.getAttachmentPaths() != null) {
                        Iterable itAttachmentPaths = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)archiveBean.getAttachmentPaths());
                        for (String attachmentPath : itAttachmentPaths) {
                            Attachment attachment;
                            block34: {
                                File attFile = attachmentBase != null ? new File(attachmentBase, attachmentPath) : new File(attachmentPath);
                                if (!attFile.isFile()) {
                                    String errorMessage = I18n.t((String)"faxtomail.archives.import.error.invalidAttachmentPath", (Object[])new Object[]{attachmentPath});
                                    throw new InvalidArchiveImportBeanException(errorMessage, archiveBean);
                                }
                                attachment = (Attachment)attachmentDao.newInstance();
                                attachment.setEmail(email);
                                attachment.setTopiaId(this.getTopiaId(Attachment.class, (TopiaEntity)attachment));
                                AttachmentFile attachmentFile = (AttachmentFile)attachmentFileDao.newInstance();
                                attachmentFile.setFilename(attFile.getName());
                                try {
                                    attachmentFile.setContent(FileUtils.readFileToByteArray((File)attFile));
                                }
                                catch (IOException e) {
                                    String errorMessage = I18n.t((String)"faxtomail.archives.import.error.readingAttachmentFile", (Object[])new Object[]{attachmentPath});
                                    throw new InvalidArchiveImportBeanException(errorMessage, archiveBean);
                                }
                                attachmentFile.setTopiaId(this.getTopiaId(AttachmentFile.class, (TopiaEntity)attachmentFile));
                                statelessSession.insert((Object)attachmentFile);
                                attachment.setOriginalFile(attachmentFile);
                                try {
                                    this.convertIfNecessary(attachment);
                                }
                                catch (IOException e) {
                                    if (!log.isErrorEnabled()) break block34;
                                    log.error((Object)"error while converting attachment", (Throwable)e);
                                }
                            }
                            statelessSession.insert((Object)attachment);
                        }
                        statelessSession.update((Object)email);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("add archive " + index));
                        }
                    }
                    if (index % commitThreshold != 0 && iterator.hasNext()) continue;
                    transaction.commit();
                    transaction = statelessSession.beginTransaction();
                    result.addNbImportedArchives(toCommitBeans.size());
                    toCommitBeans.clear();
                }
                catch (InvalidArchiveImportBeanException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    notImportedBeans.add(e.getBean());
                }
                catch (HibernateException | TopiaQueryException e) {
                    String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                    log.error((Object)message, e);
                    String errorMessage = I18n.t((String)"faxtomail.archives.import.error.persistence", (Object[])new Object[0]);
                    for (ArchiveImportExportBean bean : toCommitBeans) {
                        bean.setError(errorMessage);
                        notImportedBeans.add(bean);
                    }
                    toCommitBeans.clear();
                    while (iterator.hasNext()) {
                        ArchiveImportExportBean next = (ArchiveImportExportBean)((Object)iterator.next());
                        next.setError(errorMessage);
                        notImportedBeans.add(next);
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                throw new ApplicationTechnicalException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(importer);
                IOUtils.closeQuietly((InputStream)inputStream);
                transaction.rollback();
                statelessSession.close();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)importer);
        IOUtils.closeQuietly((InputStream)inputStream);
        transaction.rollback();
        statelessSession.close();
        if (!notImportedBeans.isEmpty()) {
            try {
                result.addNbImportErrors(notImportedBeans.size());
                Export exporter = Export.newExport((ExportModel)archiveImportExportModel, notImportedBeans);
                String fileName = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddhhmmss") + "-" + UUID.randomUUID() + ".csv";
                File errorFile = new File(this.getApplicationConfig().getDataDirectory(), fileName);
                exporter.write(errorFile);
                result.setErrorFile(errorFile);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return result;
    }

    protected String getTopiaId(Class clazz, TopiaEntity entity) {
        return this.getPersistenceContext().getTopiaIdFactory().newTopiaId(clazz, entity);
    }

    @Override
    public long getArchivedMailCount() {
        EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
        long result = emailDao.forDemandStatusEquals(DemandStatus.ARCHIVED).count();
        return result;
    }

    @Override
    public List<String> decomposeMultipartEmail(List<Attachment> attachments, Part part) throws Exception {
        return this.decomposeMultipartEmail(attachments, part, 0);
    }

    protected List<String> decomposeMultipartEmail(List<Attachment> attachments, Part part, int decomposingForwardedEmail) throws Exception {
        List<String> result = null;
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();
        for (int j = 0; j < multiPartCount; ++j) {
            String contentID;
            String fileName;
            MimeBodyPart bp;
            block17: {
                bp = (MimeBodyPart)mimeMultipart.getBodyPart(j);
                String disposition = bp.getDisposition();
                if (bp.isMimeType("text/*") && !"attachment".equals(disposition)) {
                    Charset charset = FaxToMailServiceUtils.getCharset((Part)bp);
                    String content = IOUtils.toString((InputStream)bp.getInputStream(), (Charset)charset);
                    if (bp.isMimeType("text/plain")) {
                        if (!StringUtils.isNotBlank((CharSequence)content)) continue;
                        String name = decomposingForwardedEmail > 0 ? I18n.t((String)"faxtomail.email.content.attachment.forwardedFileName", (Object[])new Object[]{decomposingForwardedEmail}) : I18n.t((String)"faxtomail.email.content.attachment.plainFileName", (Object[])new Object[0]);
                        Attachment attachment = this.convertTextToPdf(content, name);
                        attachments.add(attachment);
                        continue;
                    }
                    if (result == null) {
                        result = new ArrayList<String>();
                    }
                    result.add(content);
                    continue;
                }
                if (bp.isMimeType("multipart/*")) {
                    List<String> htmlContent = this.decomposeMultipartEmail(attachments, (Part)bp, decomposingForwardedEmail);
                    if (htmlContent == null) continue;
                    result = htmlContent;
                    continue;
                }
                if (bp.isMimeType("message/*")) {
                    Attachment attachment;
                    block16: {
                        attachment = null;
                        String fileName2 = I18n.t((String)"faxtomail.email.content.attachment.forwardedFileName", (Object[])new Object[]{++decomposingForwardedEmail}) + ".pdf";
                        try {
                            List<String> content = this.decomposeMultipartEmail(attachments, (Part)bp, decomposingForwardedEmail);
                            if (content != null) {
                                attachment = this.convertHTMLToPdf(attachments, content, fileName2);
                            }
                        }
                        catch (Exception e) {
                            Charset charset = FaxToMailServiceUtils.getCharset((Part)bp);
                            String content = IOUtils.toString((InputStream)bp.getInputStream(), (Charset)charset);
                            if (!StringUtils.isNotBlank((CharSequence)content)) break block16;
                            attachment = this.convertTextToPdf(content, fileName2);
                        }
                    }
                    if (attachment == null) continue;
                    attachments.add(attachment);
                    continue;
                }
                fileName = bp.getFileName();
                String[] headers = bp.getHeader("Content-ID");
                contentID = null;
                if (headers != null) {
                    contentID = headers[0];
                    contentID = contentID.replaceFirst("^<(.*)>$", "$1");
                }
                if (fileName == null && contentID == null) {
                    fileName = I18n.t((String)"faxtomail.email.content.attachment.unnamed", (Object[])new Object[]{attachments.size()});
                } else if (fileName == null) {
                    fileName = contentID;
                }
                try {
                    fileName = MimeUtility.decodeText((String)fileName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("FileName : " + fileName + ", Content-ID : " + contentID));
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    if (!log.isWarnEnabled()) break block17;
                    log.warn((Object)"Can't debug email file name", (Throwable)ex);
                }
            }
            DataHandler dh = bp.getDataHandler();
            AttachmentImpl attachment = new AttachmentImpl();
            attachment.setAddedByUser(false);
            AttachmentFile attachmentFile = this.getAttachmentFileFromStream(dh.getInputStream());
            attachmentFile.setFilename(fileName);
            attachment.setOriginalFile(attachmentFile);
            attachment.setContentId(contentID);
            this.convertIfNecessary((Attachment)attachment);
            attachments.add((Attachment)attachment);
        }
        return result;
    }

    @Override
    public Attachment convertIfNecessary(Attachment attachment) throws IOException {
        ExtensionCommand command;
        String filename = attachment.getOriginalFileName();
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isNotBlank((CharSequence)extension) && (command = this.getConfigurationService().getExtensionCommand(extension)) != null && StringUtils.isNotBlank((CharSequence)command.getConvertToPdfCommand())) {
            attachment = this.convertToPdf(attachment, command);
        }
        return attachment;
    }

    @Override
    public Attachment convertToPdf(Attachment attachment, ExtensionCommand extensionCommand) throws IOException {
        File outfile;
        File file;
        block9: {
            String filename = attachment.getOriginalFileName();
            String basename = FilenameUtils.getBaseName((String)filename);
            String extension = FilenameUtils.getExtension((String)filename);
            file = File.createTempFile("faxtomail-" + basename, "." + extension);
            file.deleteOnExit();
            String fullname = StringUtils.removeEnd((String)file.getAbsolutePath(), (String)("." + extension));
            outfile = new File(fullname + ".pdf");
            outfile.deleteOnExit();
            FileUtils.writeByteArrayToFile((File)file, (byte[])attachment.getOriginalFile().getContent());
            String command = extensionCommand.getConvertToPdfCommand();
            String[] args = StringUtil.split((String)command, (String)" ");
            ArrayList<String> comArgs = new ArrayList<String>();
            String[] arr$ = args;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String arg;
                String localArg = arg = arr$[i$];
                localArg = localArg.replace("%f", file.getAbsolutePath());
                localArg = localArg.replace("%o", outfile.getAbsolutePath());
                comArgs.add(localArg);
            }
            ProcessBuilder pb = new ProcessBuilder(comArgs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Convert attachment with command : " + comArgs));
            }
            try {
                Process process = pb.start();
                process.waitFor();
                byte[] outContent = FileUtils.readFileToByteArray((File)outfile);
                if (outContent.length >= 1) {
                    AttachmentFileImpl editedFile = new AttachmentFileImpl();
                    editedFile.setContent(outContent);
                    editedFile.setFilename(basename + "-converted.pdf");
                    attachment.setEditedFile((AttachmentFile)editedFile);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Can't convert extension to pdf (content is empty)");
                }
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Cannot run convert command", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Cannot run convert command", (Throwable)e);
            }
        }
        file.delete();
        outfile.delete();
        return attachment;
    }

    @Override
    public Attachment convertTextToPdf(String content, String name) throws IOException, DocumentException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)content));
        Document document = new Document();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
        writer.open();
        document.setPageSize(PageSize.A4);
        document.open();
        document.add((com.itextpdf.text.Element)new Paragraph(content));
        document.close();
        writer.close();
        AttachmentFileImpl attachmentFileNew = new AttachmentFileImpl();
        attachmentFileNew.setContent(os.toByteArray());
        attachmentFileNew.setFilename(name + ".pdf");
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setOriginalFile((AttachmentFile)attachmentFileNew);
        attachment.setOriginalFileName(name + ".pdf");
        attachment.setAddedByUser(false);
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attachment convertHTMLToPdf(List<Attachment> attachments, List<String> contentList, String name) throws IOException {
        AttachmentImpl result = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ArrayList<File> fileToDelete = new ArrayList<File>();
        try {
            Node head;
            ArrayList<String> contents = new ArrayList<String>();
            for (String content : contentList) {
                content = content.replaceAll("<meta (.*?)>(</meta>)?", "");
                content = content.replaceAll("(\\w+)=([\"'])file://.*?([\"'])", "");
                for (Attachment attachment : attachments) {
                    String key = attachment.getContentId();
                    if (key == null) {
                        key = attachment.getOriginalFileName();
                    }
                    AttachmentFile attachmentFile = attachment.getOriginalFile();
                    File file = attachmentFile.getFile();
                    fileToDelete.add(file);
                    content = content.replaceAll("(\\w+)=([\"'])cid:" + Pattern.quote(key) + "([\"'])", "$1=$2" + file.toURI() + "$3");
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Mapping attachment id " + key + " to file " + file.toURI()));
                }
                content = content.replaceAll("(\\w+)=([\"'])cid:.*?([\"'])", "");
                String defaultImageIfMalformedUrl = this.serviceContext.getApplicationConfig().getDefaultImageIfMalformedUrl();
                content = FaxToMailServiceUtils.encodeImageSourcesInEmail(content, defaultImageIfMalformedUrl);
                contents.add(content);
            }
            Html2Image html2Image = Html2Image.fromHtml((String)StringUtils.join(contents, (String)"<hr/>"));
            ImageRenderer imageRenderer = html2Image.getImageRenderer().setWidth((int)PageSize.A4.getWidth());
            org.w3c.dom.Document doc = html2Image.getParser().getDocument();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            imageRenderer.saveImage((OutputStream)baos, true);
            Image image = Image.getInstance((byte[])baos.toByteArray());
            float width = image.getWidth();
            float height = image.getHeight();
            Rectangle format = PageSize.A4;
            if (width > PageSize.A4.getWidth() && width <= PageSize.A4.getHeight()) {
                format = height <= PageSize.A4.getWidth() ? PageSize.A4.rotate() : PageSize.A3;
            }
            if (width > PageSize.A3.getWidth() && width <= PageSize.A3.getHeight()) {
                format = height <= PageSize.A3.getWidth() ? PageSize.A3.rotate() : PageSize.A2;
            }
            if (width > PageSize.A2.getWidth() && width <= PageSize.A2.getHeight()) {
                format = height <= PageSize.A2.getWidth() ? PageSize.A2.rotate() : PageSize.A1;
            }
            if (width > PageSize.A1.getWidth() && width <= PageSize.A1.getHeight()) {
                format = height <= PageSize.A1.getWidth() ? PageSize.A1.rotate() : PageSize.A0;
            }
            if (width > PageSize.A0.getWidth()) {
                format = PageSize.A0.rotate();
            }
            Element style = doc.createElement("style");
            style.setTextContent("@page { size: " + format.getWidth() + "px " + format.getHeight() + "px; }");
            NodeList heads = doc.getElementsByTagName("head");
            if (heads.getLength() > 0) {
                head = heads.item(0);
            } else {
                head = doc.createElement("head");
                Element html = doc.getDocumentElement();
                html.appendChild(head);
            }
            head.appendChild(style);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(doc, null);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            AttachmentFileImpl attachmentFileNew = new AttachmentFileImpl();
            attachmentFileNew.setContent(os.toByteArray());
            attachmentFileNew.setFilename(name + ".pdf");
            result = new AttachmentImpl();
            result.setOriginalFile((AttachmentFile)attachmentFileNew);
            result.setOriginalFileName(name + ".pdf");
            result.setAddedByUser(false);
        }
        catch (DocumentException | OutOfMemoryError er) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't convert html content to pdf", er);
            }
        }
        finally {
            for (File file : fileToDelete) {
                file.delete();
            }
        }
        return result;
    }
}

