/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services;

import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import java.awt.GraphicsEnvironment;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FaxToMailServiceUtils {
    private static final Log log = LogFactory.getLog(FaxToMailServiceUtils.class);
    public static final Pattern IMG_SRC_PATTERN = Pattern.compile("src=([\"'])(.*?)([\"'])");

    public static String addFaxDomainToFaxNumber(String faxNumber, MailFolder folder) {
        while (!folder.isUseCurrentLevelFaxDomain() && folder.getParent() != null) {
            folder = folder.getParent();
        }
        int endIndex = faxNumber.indexOf(64);
        if (endIndex >= 0) {
            faxNumber = faxNumber.substring(0, endIndex);
        }
        faxNumber = faxNumber + "@" + folder.getFaxDomain();
        return faxNumber;
    }

    public static Charset getCharset(Part part) throws MessagingException {
        Charset charset;
        ContentType contentType = new ContentType(part.getContentType());
        String charsetName = contentType.getParameter("charset");
        try {
            charset = Charsets.toCharset((String)charsetName);
        }
        catch (UnsupportedCharsetException e) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    public static <T extends Enum<T>> boolean contains(Collection<T> coll, T value) {
        boolean result = false;
        if (coll != null) {
            result = coll.contains(value);
        }
        return result;
    }

    public static String getFullMailFolderPath(MailFolder folder) {
        StringBuilder sb = new StringBuilder(folder.getName());
        for (MailFolder loopFolder = folder.getParent(); loopFolder != null; loopFolder = loopFolder.getParent()) {
            sb.insert(0, "/");
            sb.insert(0, loopFolder.getName());
        }
        return sb.toString();
    }

    public static String encodeImageSourcesInEmail(String emailContent, String defaultImage) throws URIException {
        ArrayList<String> imgSrcUrls = new ArrayList<String>();
        Matcher imgSrcMatcher = IMG_SRC_PATTERN.matcher(emailContent);
        while (imgSrcMatcher.find()) {
            imgSrcUrls.add(imgSrcMatcher.group(2));
        }
        for (String imgSrcUrl : imgSrcUrls) {
            String correctImgUrl = URIUtil.encodeQuery((String)imgSrcUrl);
            try {
                new URL(correctImgUrl);
            }
            catch (MalformedURLException e) {
                GraphicsEnvironment ge;
                if (log.isErrorEnabled()) {
                    log.error((Object)("the url of the image " + imgSrcUrl + " is not correct, replace it with the default image"));
                }
                correctImgUrl = (ge = GraphicsEnvironment.getLocalGraphicsEnvironment()).isHeadlessInstance() ? "" : defaultImage;
            }
            emailContent = emailContent.replace(imgSrcUrl, correctImgUrl);
        }
        return emailContent;
    }
}

