package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu May 07 10:55:34 UTC 2015")
public abstract class GeneratedAttachmentTopiaDao<E extends Attachment> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Attachment.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.Attachment;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(String originalFileName, AttachmentFile originalFile) {
        return create(Attachment.PROPERTY_ORIGINAL_FILE_NAME, originalFileName, Attachment.PROPERTY_ORIGINAL_FILE, originalFile);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAddedByUserIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Attachment.PROPERTY_ADDED_BY_USER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAddedByUserEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Attachment.PROPERTY_ADDED_BY_USER, v);
        return result;
    }

    @Deprecated
    public E findByAddedByUser(boolean v) {
        return forAddedByUserEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAddedByUser(boolean v) {
        return forAddedByUserEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEditedFileNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Attachment.PROPERTY_EDITED_FILE_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEditedFileNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Attachment.PROPERTY_EDITED_FILE_NAME, v);
        return result;
    }

    @Deprecated
    public E findByEditedFileName(String v) {
        return forEditedFileNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEditedFileName(String v) {
        return forEditedFileNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOriginalFileNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Attachment.PROPERTY_ORIGINAL_FILE_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOriginalFileNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Attachment.PROPERTY_ORIGINAL_FILE_NAME, v);
        return result;
    }

    @Deprecated
    public E findByOriginalFileName(String v) {
        return forOriginalFileNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOriginalFileName(String v) {
        return forOriginalFileNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Attachment.PROPERTY_CONTENT_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Attachment.PROPERTY_CONTENT_ID, v);
        return result;
    }

    @Deprecated
    public E findByContentId(String v) {
        return forContentIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByContentId(String v) {
        return forContentIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOriginalFileIn(Collection<AttachmentFile> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Attachment.PROPERTY_ORIGINAL_FILE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOriginalFileEquals(AttachmentFile v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Attachment.PROPERTY_ORIGINAL_FILE, v);
        return result;
    }

    @Deprecated
    public E findByOriginalFile(AttachmentFile v) {
        return forOriginalFileEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOriginalFile(AttachmentFile v) {
        return forOriginalFileEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEditedFileIn(Collection<AttachmentFile> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Attachment.PROPERTY_EDITED_FILE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEditedFileEquals(AttachmentFile v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Attachment.PROPERTY_EDITED_FILE, v);
        return result;
    }

    @Deprecated
    public E findByEditedFile(AttachmentFile v) {
        return forEditedFileEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEditedFile(AttachmentFile v) {
        return forEditedFileEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailIn(Collection<Email> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Attachment.PROPERTY_EMAIL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEmailEquals(Email v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Attachment.PROPERTY_EMAIL, v);
        return result;
    }

    @Deprecated
    public E findByEmail(Email v) {
        return forEmailEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEmail(Email v) {
        return forEmailEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forAttachmentContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Email.class, entity);
        if (!list.isEmpty()) {
            result.put(Email.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(entity.getOriginalFile());
        tmp.add(entity.getEditedFile());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAttachmentTopiaDao<E extends Attachment>
