package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Nov 16 15:20:41 CET 2015")
public abstract class GeneratedRangeRowTopiaDao<E extends RangeRow> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) RangeRow.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.RangeRow;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommandNumberIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RangeRow.PROPERTY_COMMAND_NUMBER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommandNumberEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RangeRow.PROPERTY_COMMAND_NUMBER, v);
        return result;
    }

    @Deprecated
    public E findByCommandNumber(String v) {
        return forCommandNumberEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCommandNumber(String v) {
        return forCommandNumberEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductQuantityIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RangeRow.PROPERTY_PRODUCT_QUANTITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductQuantityEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RangeRow.PROPERTY_PRODUCT_QUANTITY, v);
        return result;
    }

    @Deprecated
    public E findByProductQuantity(Integer v) {
        return forProductQuantityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProductQuantity(Integer v) {
        return forProductQuantityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSavQuantityIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RangeRow.PROPERTY_SAV_QUANTITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSavQuantityEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RangeRow.PROPERTY_SAV_QUANTITY, v);
        return result;
    }

    @Deprecated
    public E findBySavQuantity(Integer v) {
        return forSavQuantityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySavQuantity(Integer v) {
        return forSavQuantityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQuotationQuantityIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RangeRow.PROPERTY_QUOTATION_QUANTITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQuotationQuantityEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RangeRow.PROPERTY_QUOTATION_QUANTITY, v);
        return result;
    }

    @Deprecated
    public E findByQuotationQuantity(Integer v) {
        return forQuotationQuantityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByQuotationQuantity(Integer v) {
        return forQuotationQuantityEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRangeIn(Collection<Range> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(RangeRow.PROPERTY_RANGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRangeEquals(Range v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(RangeRow.PROPERTY_RANGE, v);
        return result;
    }

    @Deprecated
    public E findByRange(Range v) {
        return forRangeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRange(Range v) {
        return forRangeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forRangeRowContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Email.class, entity);
        if (!list.isEmpty()) {
            result.put(Email.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedRangeRowTopiaDao<E extends RangeRow>
