/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.fife.rsta.ac.java.MemberCompletion;
import org.fife.rsta.ac.java.SourceCompletionProvider;
import org.fife.rsta.ac.java.Util;
import org.fife.rsta.ac.java.classreader.ClassFile;
import org.fife.rsta.ac.java.classreader.MethodInfo;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.rsta.ac.java.rjc.ast.FormalParameter;
import org.fife.rsta.ac.java.rjc.ast.Member;
import org.fife.rsta.ac.java.rjc.ast.Method;
import org.fife.rsta.ac.java.rjc.ast.TypeDeclaration;

class MethodInfoData
implements MemberCompletion.Data {
    private SourceCompletionProvider provider;
    private MethodInfo info;

    public MethodInfoData(MethodInfo info, SourceCompletionProvider provider) {
        this.info = info;
        this.provider = provider;
    }

    public String getDefinedIn() {
        return this.info.getClassFile().getClassName(false);
    }

    public String getIcon() {
        String key = null;
        int flags = this.info.getAccessFlags();
        key = org.fife.rsta.ac.java.classreader.Util.isDefault(flags) ? "methodDefaultIcon" : (org.fife.rsta.ac.java.classreader.Util.isPrivate(flags) ? "methodPrivateIcon" : (org.fife.rsta.ac.java.classreader.Util.isProtected(flags) ? "methodProtectedIcon" : (org.fife.rsta.ac.java.classreader.Util.isPublic(flags) ? "methodPublicIcon" : "methodDefaultIcon")));
        return key;
    }

    public String getSignature() {
        return this.info.getNameAndParameters();
    }

    public String getSummary() {
        ClassFile cf = this.info.getClassFile();
        File loc = this.provider.getSourceLocForClass(cf.getClassName(true));
        String summary = null;
        if (loc != null) {
            summary = this.getSummaryFromSourceLoc(loc, cf);
        }
        if (summary == null) {
            summary = this.info.getSignature();
        }
        return summary;
    }

    private String getSummaryFromSourceLoc(File loc, ClassFile cf) {
        String summary = null;
        CompilationUnit cu = Util.getCompilationUnitFromDisk(loc, cf);
        if (cu != null) {
            Iterator i = cu.getTypeDeclarationIterator();
            block0: while (i.hasNext()) {
                TypeDeclaration td = (TypeDeclaration)i.next();
                String typeName = td.getName();
                if (!typeName.equals(cf.getClassName(false))) continue;
                ArrayList<Method> contenders = null;
                Iterator j = td.getMemberIterator();
                while (j.hasNext()) {
                    Method m2;
                    Member member = (Member)j.next();
                    if (!(member instanceof Method) || !member.getName().equals(this.info.getName()) || (m2 = (Method)member).getParameterCount() != this.info.getParameterCount()) continue;
                    if (contenders == null) {
                        contenders = new ArrayList<Method>(1);
                    }
                    contenders.add(m2);
                }
                if (contenders == null) break;
                if (contenders.size() == 1) {
                    Method meth = (Method)contenders.get(0);
                    summary = meth.getDocComment();
                    break;
                }
                for (int j2 = 0; j2 < contenders.size(); ++j2) {
                    boolean match = true;
                    Method meth = (Method)contenders.get(j2);
                    for (int p = 0; p < this.info.getParameterCount(); ++p) {
                        FormalParameter fp;
                        String type2;
                        String type1 = this.info.getParameterType(p, false);
                        if (type1.equals(type2 = (fp = meth.getParameter(p)).getType().toString())) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    summary = meth.getDocComment();
                    break block0;
                }
            }
        }
        return summary;
    }

    public String getType() {
        return this.info.getReturnTypeString();
    }

    public boolean isAbstract() {
        return this.info.isAbstract();
    }

    public boolean isDeprecated() {
        return this.info.isDeprecated();
    }

    public boolean isFinal() {
        return this.info.isFinal();
    }

    public boolean isStatic() {
        return this.info.isStatic();
    }
}

