/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.AbstractLanguageSupport;
import org.fife.rsta.ac.java.JarManager;
import org.fife.rsta.ac.java.JavaCellRenderer;
import org.fife.rsta.ac.java.JavaCompletionProvider;
import org.fife.rsta.ac.java.JavaParser;
import org.fife.rsta.ac.java.rjc.ast.CompilationUnit;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class JavaLanguageSupport
extends AbstractLanguageSupport {
    private Map parserToInfoMap = new HashMap();
    private JarManager jarManager = new JarManager();

    public JavaLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setParameterAssistanceEnabled(true);
        this.setShowDescWindow(true);
    }

    public JavaCompletionProvider getCompletionProvider(RSyntaxTextArea textArea) {
        AutoCompletion ac = this.getAutoCompletionFor(textArea);
        return (JavaCompletionProvider)ac.getCompletionProvider();
    }

    public JarManager getJarManager() {
        return this.jarManager;
    }

    public JavaParser getParser(RSyntaxTextArea textArea) {
        Object parser = textArea.getClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser");
        if (parser instanceof JavaParser) {
            return (JavaParser)((Object)parser);
        }
        return null;
    }

    public void install(RSyntaxTextArea textArea) {
        JavaCompletionProvider p = new JavaCompletionProvider(this.jarManager);
        JavaAutoCompletion ac = new JavaAutoCompletion(p, textArea);
        ac.setListCellRenderer(new JavaCellRenderer());
        ac.setAutoCompleteEnabled(this.isAutoCompleteEnabled());
        ac.setAutoActivationEnabled(this.isAutoActivationEnabled());
        ac.setAutoActivationDelay(this.getAutoActivationDelay());
        ac.setParameterAssistanceEnabled(this.isParameterAssistanceEnabled());
        ac.setShowDescWindow(this.getShowDescWindow());
        ac.install((JTextComponent)textArea);
        this.installImpl(textArea, ac);
        textArea.setToolTipSupplier((ToolTipSupplier)p);
        JavaParser parser = new JavaParser(textArea);
        textArea.putClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser", (Object)parser);
        textArea.addParser((Parser)parser);
        Info info = new Info(textArea, p, parser);
        this.parserToInfoMap.put(parser, info);
    }

    public void uninstall(RSyntaxTextArea textArea) {
        this.uninstallImpl(textArea);
        JavaParser parser = this.getParser(textArea);
        Info info = (Info)this.parserToInfoMap.remove((Object)parser);
        if (info != null) {
            parser.removePropertyChangeListener("CompilationUnit", info);
        }
        textArea.removeParser((Parser)parser);
        textArea.putClientProperty((Object)"org.fife.rsta.ac.LanguageSupport.LanguageParser", null);
    }

    private class JavaAutoCompletion
    extends AutoCompletion {
        private RSyntaxTextArea textArea;

        public JavaAutoCompletion(JavaCompletionProvider provider, RSyntaxTextArea textArea) {
            super((CompletionProvider)provider);
            this.textArea = textArea;
        }

        protected int refreshPopupWindow() {
            JavaParser parser = JavaLanguageSupport.this.getParser(this.textArea);
            RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
            String style = this.textArea.getSyntaxEditingStyle();
            parser.parse(doc, style);
            return super.refreshPopupWindow();
        }
    }

    private static class Info
    implements PropertyChangeListener {
        public RSyntaxTextArea textArea;
        public JavaCompletionProvider provider;
        public JavaParser parser;

        public Info(RSyntaxTextArea textArea, JavaCompletionProvider provider, JavaParser parser) {
            this.textArea = textArea;
            this.provider = provider;
            this.parser = parser;
            parser.addPropertyChangeListener("CompilationUnit", this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("CompilationUnit".equals(name)) {
                CompilationUnit cu = (CompilationUnit)e.getNewValue();
                this.provider.setCompilationUnit(cu);
            }
        }
    }
}

