/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractAddressableByIndexData;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;

public class TupleValue
extends AbstractAddressableByIndexData<TupleValue> {
    private final TupleType type;

    TupleValue(TupleType type) {
        super(3, type.getComponentTypes().size());
        this.type = type;
    }

    @Override
    protected DataType getType(int i) {
        return this.type.getComponentTypes().get(i);
    }

    @Override
    protected String getName(int i) {
        return "component " + i;
    }

    public TupleType getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TupleValue)) {
            return false;
        }
        TupleValue that = (TupleValue)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            DataType dt = this.getType(i);
            sb.append(this.values[i] == null ? "null" : dt.format(dt.deserialize(this.values[i], 3)));
        }
        sb.append(")");
        return sb.toString();
    }
}

