/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.io.IOException;
import java.util.EnumSet;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

class Frame {
    public final Header header;
    public final ChannelBuffer body;

    private Frame(Header header, ChannelBuffer body) {
        this.header = header;
        this.body = body;
    }

    private static Frame create(ChannelBuffer fullFrame) {
        assert (fullFrame.readableBytes() >= 8) : String.format("Frame too short (%d bytes)", fullFrame.readableBytes());
        int version = fullFrame.readByte();
        byte flags = fullFrame.readByte();
        byte streamId = fullFrame.readByte();
        byte opcode = fullFrame.readByte();
        int length = fullFrame.readInt();
        assert (length == fullFrame.readableBytes());
        Header header = new Header(version &= 0x7F, flags, (int)streamId, (int)opcode);
        return new Frame(header, fullFrame);
    }

    public static Frame create(int version, int opcode, int streamId, EnumSet<Header.Flag> flags, ChannelBuffer body) {
        Header header = new Header(version, flags, streamId, opcode);
        return new Frame(header, body);
    }

    public Frame with(ChannelBuffer newBody) {
        return new Frame(this.header, newBody);
    }

    public static class Compressor
    extends OneToOneEncoder {
        private final FrameCompressor compressor;

        public Compressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            if (frame.header.opcode == Message.Request.Type.STARTUP.opcode) {
                return frame;
            }
            frame.header.flags.add(Header.Flag.COMPRESSED);
            return this.compressor.compress(frame);
        }
    }

    public static class Decompressor
    extends OneToOneDecoder {
        private final FrameCompressor compressor;

        public Decompressor(FrameCompressor compressor) {
            assert (compressor != null);
            this.compressor = compressor;
        }

        public Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            return frame.header.flags.contains((Object)Header.Flag.COMPRESSED) ? this.compressor.decompress(frame) : frame;
        }
    }

    public static class Encoder
    extends OneToOneEncoder {
        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws IOException {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            ChannelBuffer header = ChannelBuffers.buffer((int)8);
            header.writeByte(frame.header.version);
            header.writeByte(Header.Flag.serialize(frame.header.flags));
            header.writeByte(frame.header.streamId);
            header.writeByte(frame.header.opcode);
            header.writeInt(frame.body.readableBytes());
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, frame.body});
        }
    }

    public static class Decoder
    extends LengthFieldBasedFrameDecoder {
        private static final int MAX_FRAME_LENTH = 0x10000000;

        public Decoder() {
            super(0x10000000, 4, 4, 0, 0, true);
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
            try {
                ChannelBuffer frame;
                if (buffer.readableBytes() == 0) {
                    return null;
                }
                if (buffer.readableBytes() >= 4) {
                    Message.Response.Type.fromOpcode(buffer.getByte(3));
                }
                if ((frame = (ChannelBuffer)super.decode(ctx, channel, buffer)) == null) {
                    return null;
                }
                return Frame.create(frame);
            }
            catch (CorruptedFrameException e) {
                throw new DriverInternalError(e.getMessage());
            }
            catch (TooLongFrameException e) {
                throw new DriverInternalError(e.getMessage());
            }
        }
    }

    public static class Header {
        public static final int LENGTH = 8;
        public final int version;
        public final EnumSet<Flag> flags;
        public final int streamId;
        public final int opcode;

        private Header(int version, int flags, int streamId, int opcode) {
            this(version, Flag.deserialize(flags), streamId, opcode);
        }

        private Header(int version, EnumSet<Flag> flags, int streamId, int opcode) {
            this.version = version;
            this.flags = flags;
            this.streamId = streamId;
            this.opcode = opcode;
        }

        public static enum Flag {
            COMPRESSED,
            TRACING;


            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                Flag[] values = Flag.values();
                for (int n = 0; n < 8; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(values[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }
        }
    }
}

