/*
 * HPPC
 *
 * Copyright (C) 2010-2024 Carrot Search s.c. and contributors
 * All rights reserved.
 *
 * Refer to the full license file "LICENSE.txt":
 * https://github.com/carrotsearch/hppc/blob/master/LICENSE.txt
 */
package com.carrotsearch.hppc;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

@Documented
@Retention(SOURCE)
@Target({PACKAGE, TYPE, ANNOTATION_TYPE, METHOD, CONSTRUCTOR, FIELD, LOCAL_VARIABLE, PARAMETER})
public @interface Generated {
  /**
   * The value element MUST have the name of the code generator. The recommended convention is to
   * use the fully qualified name of the code generator. For example: com.acme.generator.CodeGen.
   */
  String[] value();

  /** Date when the source was generated. */
  String date() default "";

  /**
   * A place holder for any comments that the code generator may want to include in the generated
   * code.
   */
  String comments() default "";
}
