/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import java.util.BitSet;

public class SparseFloatArray {
    float[] _floats;
    BitSet _bits;
    int[] _referencePoints;
    private int _capacity;
    private static final float ON_RATIO_CUTOFF = 0.75f;
    static final int REFERENCE_POINT_EVERY = 32;

    public SparseFloatArray(float[] floats) {
        this._capacity = floats.length;
        this.condense(floats);
    }

    public SparseFloatArray(int capacity) {
        this._capacity = capacity;
        this._floats = null;
        this._bits = null;
        this._referencePoints = null;
    }

    void condense(float[] floats) {
        int i;
        if (floats.length != this._capacity) {
            throw new IllegalArgumentException("bad input float array of length " + floats.length + " for capacity: " + this._capacity);
        }
        BitSet bits = new BitSet(floats.length);
        int on = 0;
        for (i = 0; i < floats.length; ++i) {
            if (floats[i] == 0.0f) continue;
            bits.set(i);
            ++on;
        }
        if ((float)on / (float)floats.length < 0.75f) {
            if (0 == on) {
                this._floats = null;
                this._bits = null;
                this._referencePoints = null;
            } else {
                this._bits = bits;
                this._floats = new float[this._bits.cardinality()];
                this._referencePoints = new int[floats.length / 32];
                int floatsIdx = 0;
                int refIdx = 0;
                for (i = 0; i < floats.length && (i = this._bits.nextSetBit(i)) >= 0; ++i) {
                    this._floats[floatsIdx] = floats[i];
                    while (refIdx < i / 32) {
                        this._referencePoints[refIdx++] = floatsIdx;
                    }
                    ++floatsIdx;
                }
                while (refIdx < this._referencePoints.length) {
                    this._referencePoints[refIdx++] = floatsIdx;
                }
            }
        } else {
            this._floats = floats;
            this._bits = null;
        }
    }

    public float[] expand() {
        if (null == this._bits) {
            if (null == this._floats) {
                return new float[this._capacity];
            }
            return this._floats;
        }
        float[] all = new float[this._capacity];
        int floatsidx = 0;
        int idx = this._bits.nextSetBit(0);
        while (idx >= 0 && idx < this._capacity) {
            all[idx] = this._floats[floatsidx++];
            idx = this._bits.nextSetBit(idx + 1);
        }
        return all;
    }

    public float get(int idx) {
        if (null == this._bits) {
            if (null == this._floats) {
                if (idx < 0 || idx >= this._capacity) {
                    throw new ArrayIndexOutOfBoundsException("bad index: " + idx + " for SparseFloatArray representing array of length " + this._capacity);
                }
                return 0.0f;
            }
            return this._floats[idx];
        }
        if (this._bits.get(idx)) {
            int ref = idx / 32 - 1;
            int count = ref >= 0 ? this._referencePoints[ref] : 0;
            int i = idx - idx % 32;
            while ((i = this._bits.nextSetBit(i)) >= 0 && i < idx) {
                ++count;
                ++i;
            }
            return this._floats[count];
        }
        return 0.0f;
    }
}

