/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.PrimitiveMatrix;
import java.lang.reflect.Array;

public class IntMatrix
extends PrimitiveMatrix {
    private static final long serialVersionUID = 1L;

    public IntMatrix(int[] sizes) {
        super(Integer.TYPE, sizes);
    }

    public IntMatrix() {
        super(Integer.TYPE);
    }

    public synchronized void set(int x, int y, int n) {
        this.ensureCapacity(x, y);
        Object row = Array.get(this._matrix, x);
        if (row == null) {
            throw new ArrayIndexOutOfBoundsException("index out of bounds: " + x);
        }
        Array.setInt(row, y, n);
        this._rowCount = Math.max(x, this._rowCount);
        this._colCount = Math.max(y, this._colCount);
    }

    public int get(int r, int c) {
        Object row = Array.get(this._matrix, r);
        if (row == null) {
            throw new ArrayIndexOutOfBoundsException("index out of bounds: " + r);
        }
        return Array.getInt(row, c);
    }

    public synchronized int[][] toArray() {
        int[][] ret = new int[this._rowCount][this._colCount];
        for (int i = 0; i < this._rowCount; ++i) {
            Object row = Array.get(this._matrix, i);
            System.arraycopy(row, 0, ret[i], 0, this._colCount);
        }
        return ret;
    }

    public static void main(String[] args) {
        IntMatrix matrix = new IntMatrix(new int[]{2, 4});
        matrix.set(0, 0, 5);
        matrix.set(100, 100, 9);
        System.out.println(matrix);
        matrix.seal();
        System.out.println(matrix);
    }
}

