/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.impl;

import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Version;

public class QueryProducer {
    private static Logger logger = Logger.getLogger(QueryProducer.class);
    public static final String CONTENT_FIELD = "contents";
    static final SortField[] DEFAULT_SORT = new SortField[]{SortField.FIELD_SCORE};

    public static Query convert(String queryString, String defaultField) throws ParseException {
        if (queryString == null || queryString.length() == 0) {
            return null;
        }
        StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_CURRENT);
        if (defaultField == null) {
            defaultField = CONTENT_FIELD;
        }
        return new QueryParser(Version.LUCENE_CURRENT, defaultField, (Analyzer)analyzer).parse(queryString);
    }

    public Query buildQuery(String query) throws ParseException {
        return QueryProducer.convert(query, CONTENT_FIELD);
    }
}

