/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.FacetDataFetcher;
import com.browseengine.bobo.facets.data.TermFixedLengthLongArrayListFactory;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.impl.SimpleFacetHandler;
import com.browseengine.bobo.util.BigIntArray;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.index.TermDocs;

public class VirtualSimpleFacetHandler
extends SimpleFacetHandler {
    protected FacetDataFetcher _facetDataFetcher;

    public VirtualSimpleFacetHandler(String name, String indexFieldName, TermListFactory termListFactory, FacetDataFetcher facetDataFetcher, Set<String> dependsOn) {
        super(name, indexFieldName, termListFactory, dependsOn);
        this._facetDataFetcher = facetDataFetcher;
    }

    public VirtualSimpleFacetHandler(String name, TermListFactory termListFactory, FacetDataFetcher facetDataFetcher, Set<String> dependsOn) {
        this(name, name, termListFactory, facetDataFetcher, dependsOn);
    }

    @Override
    public FacetDataCache load(BoboIndexReader reader) throws IOException {
        int doc = -1;
        TreeMap<Object, LinkedList<Object>> dataMap = null;
        LinkedList docList = null;
        TermDocs termDocs = reader.termDocs(null);
        while (termDocs.next()) {
            doc = termDocs.doc();
            Object val = this._facetDataFetcher.fetch(reader, doc);
            if (val == null) continue;
            if (dataMap == null) {
                if (val instanceof long[]) {
                    if (this._termListFactory == null) {
                        this._termListFactory = new TermFixedLengthLongArrayListFactory(((long[])val).length);
                    }
                    dataMap = new TreeMap(new Comparator<Object>(){

                        @Override
                        public int compare(Object big, Object small) {
                            if (((long[])big).length != ((long[])small).length) {
                                throw new RuntimeException("" + Arrays.asList(new long[][]{(long[])big}) + " and " + Arrays.asList(new long[][]{(long[])small}) + " have different length.");
                            }
                            long r = 0L;
                            for (int i = 0; i < ((long[])big).length && (r = ((long[])big)[i] - ((long[])small)[i]) == 0L; ++i) {
                            }
                            if (r > 0L) {
                                return 1;
                            }
                            if (r < 0L) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                } else {
                    dataMap = val instanceof Comparable ? new TreeMap<Object, LinkedList>() : new TreeMap(new Comparator<Object>(){

                        @Override
                        public int compare(Object big, Object small) {
                            return String.valueOf(big).compareTo(String.valueOf(small));
                        }
                    });
                }
            }
            if ((docList = (LinkedList)dataMap.get(val)) == null) {
                docList = new LinkedList();
                dataMap.put(val, docList);
            }
            docList.add(doc);
        }
        int maxDoc = reader.maxDoc();
        int size = dataMap == null ? 1 : dataMap.size() + 1;
        BigIntArray order = new BigIntArray(maxDoc);
        TermValueList list = this._termListFactory == null ? new TermStringList(size) : this._termListFactory.createTermList(size);
        int[] freqs = new int[size];
        int[] minIDs = new int[size];
        int[] maxIDs = new int[size];
        list.add(null);
        freqs[0] = -1;
        minIDs[0] = -1;
        maxIDs[0] = -1;
        if (dataMap != null) {
            int i = 1;
            for (Map.Entry entry : dataMap.entrySet()) {
                Integer docId;
                list.add(list.format(entry.getKey()));
                docList = (LinkedList)entry.getValue();
                freqs[i] = docList.size();
                minIDs[i] = (Integer)docList.get(0);
                while ((docId = (Integer)docList.poll()) != null) {
                    doc = docId;
                    ((BigSegmentedArray)order).add(doc, i);
                }
                maxIDs[i] = doc;
                ++i;
            }
        }
        list.seal();
        FacetDataCache dataCache = new FacetDataCache(order, list, freqs, minIDs, maxIDs, FacetHandler.TermCountSize.large);
        return dataCache;
    }
}

