/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.Environment;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.proj.CADRGLoader;
import com.bbn.openmap.proj.CartesianLoader;
import com.bbn.openmap.proj.GnomonicLoader;
import com.bbn.openmap.proj.LLXYLoader;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.MercatorLoader;
import com.bbn.openmap.proj.OrthographicLoader;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionFactory
extends OMComponent
implements SoloMapComponent {
    public static final String CENTER = "CENTER";
    public static final String SCALE = "SCALE";
    public static final String HEIGHT = "HEIGHT";
    public static final String WIDTH = "WIDTH";
    public static final String DATUM = "DATUM";
    public static final String AvailableProjectionProperty = "AvailableProjections";
    public static final String ProjectionLoadersProperty = "projectionLoaders";
    protected PropertyChangeSupport pcs;
    protected Vector<ProjectionLoader> projLoaders = new Vector();

    public ProjectionFactory() {
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String loaderPrefixesString = props.getProperty(prefix + ProjectionLoadersProperty);
        if (loaderPrefixesString != null) {
            Vector<String> loaderPrefixes = PropUtils.parseSpacedMarkers(loaderPrefixesString);
            Vector<?> loaders = ComponentFactory.create(loaderPrefixes, prefix, props);
            for (Object obj : loaders) {
                if (!(obj instanceof ProjectionLoader)) continue;
                this.projLoaders.add((ProjectionLoader)obj);
            }
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.projLoaders != null) {
            StringBuffer markerlist = new StringBuffer();
            int count = 0;
            for (ProjectionLoader pl : this.projLoaders) {
                String markerName;
                if (pl instanceof PropertyConsumer) {
                    PropertyConsumer pc = (PropertyConsumer)((Object)pl);
                    markerName = pc.getPropertyPrefix();
                    props.put(markerName + ".class", pl.getClass().getName());
                    if (markerName.startsWith(prefix)) {
                        markerName = markerName.substring(prefix.length());
                    }
                    pc.getProperties(props);
                } else {
                    markerName = "projectionLoader" + count++;
                    props.put(markerName + ".class", pl.getClass().getName());
                }
                markerlist.append(" ").append(markerName);
            }
            props.put(prefix + ProjectionLoadersProperty, markerlist.toString());
        }
        return props;
    }

    public String[] getAvailableProjections() {
        ArrayList<ProjectionLoader> projLoaders = new ArrayList<ProjectionLoader>(this.getProjectionLoaders());
        int nProjections = projLoaders.size();
        String[] projNames = new String[nProjections];
        int i = 0;
        Iterator it = projLoaders.iterator();
        while (it.hasNext()) {
            projNames[i++] = ((ProjectionLoader)it.next()).getPrettyName();
        }
        return projNames;
    }

    public Class<? extends Projection> getProjClassForName(String name) {
        if (name != null) {
            for (ProjectionLoader loader : this.getProjectionLoaders()) {
                if (!name.equalsIgnoreCase(loader.getPrettyName())) continue;
                return loader.getProjectionClass();
            }
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public Projection makeProjection(String projClassName, Projection p) {
        Object ctr = p.getCenter();
        return this.makeProjection(projClassName, (Point2D)ctr, p.getScale(), p.getWidth(), p.getHeight());
    }

    public Projection makeProjection(String projClassName, Point2D center, float scale, int width, int height) {
        if (projClassName == null) {
            throw new ProjectionException("No projection class name specified");
        }
        try {
            return this.makeProjection(Class.forName(projClassName), center, scale, width, height);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ProjectionException("Projection class " + projClassName + " not found");
        }
    }

    public Projection makeProjection(Class<? extends Projection> projClass, Point2D center, float scale, int width, int height) {
        ProjectionLoader loader = MercatorLoader.defaultMercator;
        Iterator<ProjectionLoader> it = this.iterator();
        while (it.hasNext()) {
            ProjectionLoader pl = it.next();
            if (pl.getProjectionClass() != projClass) continue;
            loader = pl;
        }
        return this.makeProjection(loader, center, scale, width, height);
    }

    public Projection getDefaultProjectionFromEnvironment(Environment e) {
        return this.getDefaultProjectionFromEnvironment(e, 0, 0);
    }

    public Projection getDefaultProjectionFromEnvironment(Environment environment, int width, int height) {
        Projection proj = null;
        int w = width <= 0 ? Environment.getInteger("openmap.Width", 640) : width;
        int h = height <= 0 ? Environment.getInteger("openmap.Height", 480) : height;
        try {
            proj = this.makeProjection(Environment.get("openmap.Projection"), (Point2D)new LatLonPoint.Float(Environment.getFloat("openmap.Latitude", 0.0f), Environment.getFloat("openmap.Longitude", 0.0f)), Environment.getFloat("openmap.Scale", Float.POSITIVE_INFINITY), w, h);
        }
        catch (ProjectionException pe) {
            if (Debug.debugging("proj")) {
                Debug.output("ProjectionFactory.getDefaultProjectionFromEnvironment(): Can't use (openmap.Projection = " + Environment.get("openmap.Projection") + ") property as a projection class, need a class name instead.  Using default of com.bbn.openmap.proj.Mercator.");
            }
            proj = this.makeProjection(Mercator.class, (Point2D)new LatLonPoint.Float(Environment.getFloat("openmap.Latitude", 0.0f), Environment.getFloat("openmap.Longitude", 0.0f)), Environment.getFloat("openmap.Scale", Float.POSITIVE_INFINITY), w, h);
        }
        return proj;
    }

    public Projection makeProjection(ProjectionLoader loader, Point2D center, float scale, int width, int height) {
        return this.makeProjection(loader, center, scale, width, height, null);
    }

    public Projection makeProjection(ProjectionLoader loader, Point2D center, float scale, int width, int height, Properties projProps) {
        Projection proj = null;
        if (loader == null) {
            Debug.error("ProjectionFactory.makeProjection() not given a ProjectionLoader to use to create a Projection");
            return proj;
        }
        if (projProps == null) {
            projProps = new Properties();
        }
        projProps.put(CENTER, center);
        projProps.put(SCALE, Float.toString(scale));
        projProps.put(WIDTH, Integer.toString(width));
        projProps.put(HEIGHT, Integer.toString(height));
        proj = loader.create(projProps);
        if (proj == null) {
            Debug.error("ProjectionFactory.makeProjection() tried to create a Projection from a " + loader.getPrettyName() + ", " + loader.getProjectionClass().getName() + ", failed.");
        }
        return proj;
    }

    public void addProjectionLoader(ProjectionLoader loader) {
        this.projLoaders.add(loader);
        this.fireLoadersChanged();
    }

    public boolean removeProjectionLoader(ProjectionLoader loader) {
        boolean removed = this.projLoaders.remove(loader);
        if (removed) {
            this.fireLoadersChanged();
        }
        return removed;
    }

    public void clearProjectionLoaders() {
        if (!this.projLoaders.isEmpty()) {
            this.projLoaders.clear();
            this.fireLoadersChanged();
        }
    }

    public Iterator<ProjectionLoader> iterator() {
        return this.projLoaders.iterator();
    }

    public int numProjections() {
        return this.projLoaders.size();
    }

    public Collection<ProjectionLoader> getProjectionLoaders() {
        return Collections.unmodifiableCollection(this.projLoaders);
    }

    protected void fireLoadersChanged() {
        this.pcs.firePropertyChange(AvailableProjectionProperty, null, this.projLoaders);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (pcl != null) {
            this.pcs.addPropertyChangeListener(pcl);
            pcl.propertyChange(new PropertyChangeEvent(this, AvailableProjectionProperty, null, this.projLoaders));
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        if (pcl != null) {
            this.pcs.addPropertyChangeListener(propertyName, pcl);
            pcl.propertyChange(new PropertyChangeEvent(this, AvailableProjectionProperty, null, this.projLoaders));
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propertyName, pcl);
    }

    @Override
    public void findAndInit(Object obj) {
        if (obj instanceof ProjectionLoader) {
            this.addProjectionLoader((ProjectionLoader)obj);
        }
        if (obj instanceof MapBean) {
            ((MapBean)obj).setProjectionFactory(this);
        }
    }

    @Override
    public void findAndUndo(Object obj) {
        if (obj instanceof ProjectionLoader) {
            this.removeProjectionLoader((ProjectionLoader)obj);
        }
    }

    public static void loadDefaultProjections(MapHandler mapHandler) {
        mapHandler.add(ProjectionFactory.loadDefaultProjections(new ProjectionFactory()));
    }

    public static ProjectionFactory loadDefaultProjections() {
        return ProjectionFactory.loadDefaultProjections(new ProjectionFactory());
    }

    public static ProjectionFactory loadDefaultProjections(ProjectionFactory pf) {
        if (pf != null && pf.numProjections() == 0) {
            pf.addProjectionLoader(new MercatorLoader());
            pf.addProjectionLoader(new OrthographicLoader());
            pf.addProjectionLoader(new CADRGLoader());
            pf.addProjectionLoader(new LLXYLoader());
            pf.addProjectionLoader(new GnomonicLoader());
            pf.addProjectionLoader(new CartesianLoader());
        }
        return pf;
    }
}

