/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.labeled;

import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.labeled.LabeledOMGraphic;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;

public class LabeledOMPoly
extends OMPoly
implements LabeledOMGraphic {
    protected OMText label;
    protected Point offset;
    protected boolean locateAtCenter = false;
    protected int index = 0;
    boolean matchPolyPaint = true;
    Point handyPoint = new Point();

    public LabeledOMPoly() {
    }

    public LabeledOMPoly(double[] llPoints, int units, int lType) {
        super(llPoints, units, lType);
    }

    public LabeledOMPoly(double[] llPoints, int units, int lType, int nsegs) {
        super(llPoints, units, lType, nsegs);
    }

    public LabeledOMPoly(int[] xypoints) {
        super(xypoints);
    }

    public LabeledOMPoly(int[] xPoints, int[] yPoints) {
        super(xPoints, yPoints);
    }

    public LabeledOMPoly(double latPoint, double lonPoint, int[] xypoints, int cMode) {
        super(latPoint, lonPoint, xypoints, cMode);
    }

    public LabeledOMPoly(double latPoint, double lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(latPoint, lonPoint, xPoints, yPoints, cMode);
    }

    public void setText(String label) {
        this.getLabel().setData(label);
    }

    public String getText() {
        return this.getLabel().getData();
    }

    protected OMText getLabel() {
        if (this.label == null) {
            this.label = new OMText(-1, -1, "", 0);
        }
        return this.label;
    }

    public void setFont(Font f) {
        this.getLabel().setFont(f);
    }

    public Font getFont() {
        return this.getLabel().getFont();
    }

    public void setJustify(int just) {
        this.getLabel().setJustify(just);
    }

    public int getJustify() {
        return this.getLabel().getJustify();
    }

    public void setLocateAtCenter(boolean set) {
        this.locateAtCenter = set;
        if (set) {
            this.setJustify(1);
            this.getLabel().setFMHeight(3);
        }
    }

    public boolean isLocateAtCenter() {
        return this.locateAtCenter;
    }

    protected double calculateProjectedArea() {
        int j = 0;
        double area = 0.0;
        float[] xpts = this.xpoints[0];
        float[] ypts = this.ypoints[0];
        int npoints = xpts.length;
        for (int i = 0; i < npoints; ++i) {
            j = (i + 1) % npoints;
            area += (double)(xpts[i] * ypts[j]);
            area -= (double)(ypts[i] * xpts[j]);
        }
        return area / 2.0;
    }

    public Point getCenter() {
        if (this.getNeedToRegenerate()) {
            return null;
        }
        float cx = 0.0f;
        float cy = 0.0f;
        float A = (float)this.calculateProjectedArea();
        int j = 0;
        float factor = 0.0f;
        float[] xpts = this.xpoints[0];
        float[] ypts = this.ypoints[0];
        int npoints = xpts.length;
        for (int i = 0; i < npoints; ++i) {
            j = (i + 1) % npoints;
            factor = xpts[i] * ypts[j] - xpts[j] * ypts[i];
            cx += (xpts[i] + xpts[j]) * factor;
            cy += (ypts[i] + ypts[j]) * factor;
        }
        factor = 1.0f / (A *= 6.0f);
        Point center = new Point(Math.round(cx *= factor), Math.round(cy *= factor));
        return center;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setOffset(Point p) {
        this.offset = p;
    }

    public Point getOffset() {
        if (this.offset == null) {
            this.offset = new Point();
        }
        return this.offset;
    }

    public void setRotationAngle(double angle) {
        this.getLabel().setRotationAngle(angle);
    }

    public double getRotationAngle() {
        return this.getLabel().getRotationAngle();
    }

    public void setLinePaint(Paint paint) {
        super.setLinePaint(paint);
        if (this.matchPolyPaint) {
            this.getLabel().setLinePaint(paint);
        }
    }

    public void setTextPaint(Paint paint) {
        if (paint != null) {
            this.matchPolyPaint = false;
            this.getLabel().setLinePaint(paint);
        }
    }

    protected Point getTextPoint(Projection proj) {
        if (this.renderType == 1 && proj instanceof GeoProj) {
            int numPoints = this.rawllpts.length / 2;
            if (this.rawllpts.length < 2) {
                this.handyPoint.setLocation(-10, -10);
                return this.handyPoint;
            }
            if (this.locateAtCenter) {
                this.handyPoint = this.getCenter();
            } else {
                if (this.index < 0) {
                    this.index = 0;
                }
                if (this.index > numPoints) {
                    this.index = numPoints - 1;
                }
                ((GeoProj)proj).forward(this.rawllpts[2 * this.index], this.rawllpts[2 * this.index + 1], (Point2D)this.handyPoint, true);
            }
        } else {
            float[][] x = this.xpoints;
            float[][] y = this.ypoints;
            if (x[0].length < 2) {
                this.handyPoint.setLocation(-10, -10);
                return this.handyPoint;
            }
            if (this.locateAtCenter) {
                this.handyPoint = this.getCenter();
            } else {
                if (this.index < 0) {
                    this.index = 0;
                }
                if (this.index >= x[0].length) {
                    this.index = x[0].length - 1;
                }
                this.handyPoint.setLocation(x[0][this.index], y[0][this.index]);
            }
        }
        return this.handyPoint;
    }

    public boolean generate(Projection proj) {
        boolean ret = super.generate(proj);
        Point p = this.getTextPoint(proj);
        if (p != null) {
            this.label.setX((int)(p.getX() + this.getOffset().getX()));
            this.label.setY((int)(p.getY() + this.getOffset().getY()));
            if (Debug.debugging("labeled")) {
                Debug.output("Setting label(" + this.label.getData() + ") to " + p);
            }
            this.label.generate(proj);
        }
        return ret;
    }

    public void render(Graphics g) {
        super.render(g);
        this.label.render(g);
    }
}

