/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.omGraphics.geom.NonRegional;
import com.bbn.openmap.util.PropUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class GraphicAttributes
extends DrawingAttributes
implements ActionListener,
Serializable,
OMGraphicConstants {
    public static final String lineTypeProperty = "lineType";
    public static final String renderTypeProperty = "renderType";
    protected int lineType = 1;
    protected int renderType = 2;
    protected boolean enableLineTypeChoice = true;
    public static final GraphicAttributes DEFAULT = new GraphicAttributes();
    private I18n i18n = Environment.getI18n();

    public GraphicAttributes() {
    }

    public GraphicAttributes(Properties props) {
        super(props);
    }

    public GraphicAttributes(String prefix, Properties props) {
        super(prefix, props);
    }

    public static GraphicAttributes getGADefaultClone() {
        return (GraphicAttributes)DEFAULT.clone();
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        if (props == null) {
            return;
        }
        String realPrefix = prefix != null ? prefix + "." : "";
        this.lineType = PropUtils.intFromProperties(props, realPrefix + lineTypeProperty, 0);
        this.renderType = PropUtils.intFromProperties(props, realPrefix + renderTypeProperty, 0);
    }

    public Object clone() {
        GraphicAttributes clone = new GraphicAttributes();
        this.setTo(clone);
        return clone;
    }

    public void setTo(GraphicAttributes clone) {
        super.setTo(clone);
        clone.renderType = this.renderType;
        clone.lineType = this.lineType;
        clone.enableLineTypeChoice = this.enableLineTypeChoice;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int lt) {
        int oldLineType = this.lineType;
        this.lineType = lt == 1 || lt == 3 || lt == 2 ? lt : 0;
        this.propertyChangeSupport.firePropertyChange(lineTypeProperty, oldLineType, this.lineType);
    }

    public int getRenderType() {
        return this.renderType;
    }

    public void setRenderType(int rt) {
        int oldRenderType = this.renderType;
        this.renderType = rt == 2 || rt == 1 || rt == 3 ? rt : 0;
        this.propertyChangeSupport.firePropertyChange(renderTypeProperty, oldRenderType, this.renderType);
    }

    public void setFrom(OMGraphic graphic) {
        this.setFrom(graphic, false);
    }

    public void setFrom(OMGraphic graphic, boolean resetGUI) {
        if (graphic == null) {
            return;
        }
        super.setFrom(graphic, false);
        this.lineType = graphic.getLineType();
        this.renderType = graphic.getRenderType();
        this.enableLineTypeChoice = graphic.hasLineTypeChoice();
        if (resetGUI) {
            this.resetGUI();
        }
    }

    public void setTo(OMGraphic graphic) {
        this.setTo(graphic, false);
    }

    public void setTo(OMGraphic graphic, boolean resetGUI) {
        if (graphic == null) {
            return;
        }
        super.setTo(graphic, false);
        graphic.setLineType(this.lineType);
        graphic.setRenderType(this.renderType);
        if (resetGUI) {
            this.enableLineTypeChoice = graphic.hasLineTypeChoice();
            this.enableFillPaintChoice = !(graphic instanceof NonRegional);
            this.resetGUI();
        }
    }

    public void setEnableLineTypeChoice(boolean value) {
        this.enableLineTypeChoice = value;
    }

    public boolean getEnableLineTypeChoice() {
        return this.enableLineTypeChoice;
    }

    protected void setPreStrokeMenuOptions(JPopupMenu popup) {
        super.setPreStrokeMenuOptions(popup);
        JMenu ltm = this.getLineTypeMenu();
        if (ltm != null) {
            popup.add(ltm);
        }
    }

    public JMenu getLineTypeMenu() {
        JMenu lineTypeMenu = null;
        if (this.renderType == 1 && this.enableLineTypeChoice) {
            lineTypeMenu = new JMenu(this.i18n.get(GraphicAttributes.class, "Line_Type", "Line Type"));
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String command = ae.getActionCommand();
                    try {
                        GraphicAttributes.this.setLineType(Integer.parseInt(command));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            };
            ButtonGroup group = new ButtonGroup();
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(this.i18n.get(DrawingAttributes.class, "Great_Circle", "Great Circle"), this.lineType == 3);
            button.setActionCommand(String.valueOf(3));
            button.addActionListener(listener);
            lineTypeMenu.add(button);
            button = new JRadioButtonMenuItem(this.i18n.get(GraphicAttributes.class, "Rhumb", "Rhumb"), this.lineType == 2);
            button.setActionCommand(String.valueOf(2));
            group.add(button);
            button.addActionListener(listener);
            lineTypeMenu.add(button);
            button = new JRadioButtonMenuItem(this.i18n.get(GraphicAttributes.class, "Straight", "Straight"), this.lineType == 1);
            button.setActionCommand(String.valueOf(1));
            group.add(button);
            button.addActionListener(listener);
            lineTypeMenu.add(button);
        }
        return lineTypeMenu;
    }
}

